window.VRoid = {};

//インポートしたファイルにはキャッシュ対策が施されていないため、ライブラリアップデート時には注意すること

import * as THREE from './module/three/three.module.min.js';
import { GLTFLoader } from './module/three/loaders/GLTFLoader.js';

import { EffectComposer } from './module/three/postprocessing/EffectComposer.js';
import { RenderPass } from './module/three/postprocessing/RenderPass.js';
import { ShaderPass } from './module/three/postprocessing/ShaderPass.js';

import { VRMLoaderPlugin, VRMUtils, VRMHumanBoneName, VRMExpression, VRMExpressionMorphTargetBind, VRMHumanBoneList } from './module/three-vrm/three-vrm.module.min.js';

(function(){
	//セーブデータ用のオブジェクト
	TYRANO.kag.stat.VRoid = {
		layer:{},
		model:{},
		img:{},
		module:{}
	};

	VRoid.three = {
		layer:{},
		model:{},
		img:{},
		vrma: {},
		fbx: {},
		animEmo: {},


		test: function (pm) {

		},

		//表示レイヤーの作成
		// VRoid.three.create()
		create: function (pm) {

			const {
				layerID,
				layer = "0",
				name = "",
				zindex = 10,
				visible = true,
				antialias = true,
				samples = 4,
				quality = 1,
				lightType = "directional",
				limitFPS = false,
				perspective = true,
				fov = 30,
				near = 0.01,
				far = 100,
				highLight = 0.3141592653589793,
				useWebGL2 = true,
				showFPS = true,
				screenshot = true,

				x = 0,
				y = 0,
				z = 0,
				rotX = 0,
				rotY = 0,
				rotZ = 0,
				scaleX = 1,
				scaleY = 1,
				scaleZ = 1,
				zoom = 1,
			} = pm;


			//WebGL1のみ環境テスト用
			const WebGL1Test = false
			if (WebGL1Test) console.warn("WebGL1Test")
		
			if (document.getElementById(layerID)) {
				this.error(layerID + " 同一IDのレイヤーは作成できません。")
				return
			}

			//オブジェクトの初期化
			const thisLayer = this.layer[layerID] = {};

			//セーブデータ用のオブジェクトを作成
			const statVRoid = TYRANO.kag.stat.VRoid;
			pm.type = "layer"
			if (!statVRoid.layer[layerID]) statVRoid.layer[layerID] = $.extend(true,{}, pm);
			const saveLayer = statVRoid.layer[layerID];

			// シーンの準備
			const scene = thisLayer.scene = new THREE.Scene()
			scene.name = layerID;

			// ライトの設定 AmbientLight or DirectionalLight
			//ライトのセーブデータがなければ初期化
			if (!saveLayer.light) {
				saveLayer.light = {
					layerID: layerID,
					r: 1,
					g: 1,
					b: 1,
					x: 0,
					y: 0,
					z: -1,
					val: 1,	//Math.PIをかける前の数字を設定
				};
			}
			
			const saveLight = saveLayer.light
			if (lightType == "ambient") {
				thisLayer.light = new THREE.AmbientLight(0xffffff)
			} else {
				thisLayer.light = new THREE.DirectionalLight(0xffffff)
			}
			const lightObj = thisLayer.light
			lightObj.position.set(saveLight.x, saveLight.y, saveLight.z).normalize()
			lightObj.intensity = saveLight.val * Math.PI
			scene.add(lightObj)
			
			//霧を表示させるテスト(色, 開始距離, 終点距離)
			//scene.fog = new THREE.Fog(0xffffff, -1, 10);

			const scWidth = Number(TYRANO.kag.config.scWidth)
			const scHeight = Number(TYRANO.kag.config.scHeight)
			const aspect = scWidth / scHeight

			// カメラの準備
			if (perspective) {
				thisLayer.camera = new THREE.PerspectiveCamera(fov, aspect, near, far)
			} else {
				thisLayer.camera = new THREE.OrthographicCamera((fov * aspect) / -100, (fov * aspect) / 100, fov / 100, fov / -100, near, far);
			}
			
			const camera = thisLayer.camera
			camera.position.set(x, y, z)
			camera.rotation.set(rotX, rotY, rotZ)
			camera.scale.set(scaleX, scaleY, scaleZ)
			camera.zoom = zoom
			camera.updateProjectionMatrix()

			// レンダラーの準備
			if (!useWebGL2 || WebGL1Test) {
				thisLayer.renderer = new THREE.WebGL1Renderer({ antialias: false, alpha: true, preserveDrawingBuffer: screenshot })
			} else {
				//GL2はここでantialiasをかけない
				thisLayer.renderer = new THREE.WebGLRenderer({ antialias: false, alpha: true, preserveDrawingBuffer: screenshot })
			}
			const renderer = thisLayer.renderer

			//パフォーマンス警告を表示させない
			renderer.debug.checkShaderErrors = false
			renderer.setSize(scWidth, scHeight)
			renderer.outputColorSpace = THREE.SRGBColorSpace;
			renderer.setClearColor(0x000000, 0);

			//renderer.outputColorSpace = THREE.LinearSRGBColorSpace;
			//renderer.useLegacyLights = true

			// レンダラーに指定した属性を付与
			const domElement = renderer.domElement;
			domElement.id = layerID;
			domElement.classList.add(layerID, "VRoidCanvasLayer");

			domElement.style.position = "absolute";
			domElement.style.zIndex = zindex;
			domElement.style.pointerEvents = "none";

			//レイヤーを追加
			TYRANO.kag.layer.getLayer(layer).append(domElement);

			//name指定があったらclassを追加
			if (name) $.setName($("#" + layerID), name)

			//composerのセットアップ
			const isWebGL2Available = () => {
				try {
					return !!window.WebGL2RenderingContext && document.createElement('canvas').getContext('webgl2');
				} catch (e) {
					return false;
				}
			};

			const renderTargetOptions = {
				minFilter: THREE.LinearFilter,
				magFilter: THREE.LinearFilter,
				colorSpace: THREE.SRGBColorSpace,
			}
			if (antialias && isWebGL2Available() && !WebGL1Test) renderTargetOptions.samples = samples

			const renderTarget = thisLayer.renderTarget = new THREE.WebGLRenderTarget(1, 1, renderTargetOptions)
			const composer = thisLayer.composer = new EffectComposer(renderer, renderTarget);
			composer.setSize(scWidth, scHeight)

			const fadePass = thisLayer.fadePass = new ShaderPass({
				uniforms: {
					'tDiffuse': { value: null },
					'opacity': { value: 1.0 }
				},
				vertexShader: `
				varying vec2 vUv;
				void main() {
					vUv = uv;
					gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );
				}
				`,
				fragmentShader: `
					uniform float opacity;
					uniform sampler2D tDiffuse;
					varying vec2 vUv;

					void main() {
						gl_FragColor = linearToOutputTexel(texture2D( tDiffuse, vUv )) * opacity;
					}
				`
			});
			const opacity = fadePass.uniforms.opacity

			if (!visible) {
				opacity.value = 0;
			} else {
				opacity.value = 1;
			}

			composer.addPass( new RenderPass(scene, camera) );
			composer.addPass(fadePass);
			const passes = composer.passes;

			//オフスクリーンレンダリング用
			//ここを通さないと透過PNGの透過度に問題が出る
			const fadeMaterial = new THREE.ShaderMaterial({
				uniforms: {
					tDiffuse: { value: renderTarget.texture },
					'opacity': { value: 1.0 }
				},
				vertexShader: `
					varying vec2 vUv;
					void main() {
						vUv = uv;
						gl_Position = vec4(position, 1.0);
					}
				`,
				fragmentShader: `
					uniform float opacity;
					uniform sampler2D tDiffuse;
					varying vec2 vUv;

					void main() {
						gl_FragColor = linearToOutputTexel(texture2D(tDiffuse, vUv)) * opacity;
					}
				`
			});

			//opacityをfadePassと同期
			fadeMaterial.uniforms.opacity = opacity
			const fadeQuad = new THREE.Mesh(new THREE.PlaneGeometry(2, 2), fadeMaterial);
			fadeQuad.frustumCulled = false;

			const fadeScene = thisLayer.fadeScene = new THREE.Scene();
			fadeScene.add(fadeQuad);
			const fadeCamera = thisLayer.fadeCamera = new THREE.Camera();

			// アニメーションループの開始
			let halfFPS = true;
			let zeroCount = 0

			const clock = new THREE.Clock();
			const thisModel = this.model

			//動的にPixelRatioを更新する
			let tmpRatio
			//何フレームごとに更新をチェックするか
			const updateRatioVal = 30
			let countRatio = updateRatioVal
			const minRatio = Math.min(1, window.devicePixelRatio) * quality
			//4k対応
			const maxRatio = 3 * quality
			let baseWidth = scWidth / window.devicePixelRatio
			//1.25倍にqualityで補正する
			baseWidth = Math.max(scWidth / 1.25, baseWidth / maxRatio)

			//ウインドウサイズ計測用の要素を作成する
			if (!document.getElementById("VRoidBoundingClientRect")) $("#tyrano_base").append("<div id='VRoidBoundingClientRect' style='position: absolute; z-index: -1; top: 0; left: 0; width: " + scWidth + "px'></div>")
			const boundingClientRect = document.getElementById("VRoidBoundingClientRect")

			function tick() {
				if (thisLayer) {

					thisLayer.tickID = requestAnimationFrame(tick)

					if (limitFPS && (halfFPS = !halfFPS)) return;

					//FPS計測
					if (thisLayer.stats) thisLayer.stats.begin();

					//30フレームに1回PixelRatioの更新を確認
					if (++countRatio > updateRatioVal) {
						countRatio = 0;
						//getBoundingClientRectが取得できないときは処理しない
						const ClientRect = boundingClientRect.getBoundingClientRect().width
						if (ClientRect) {
							const ratio = Math.max(minRatio, Math.min(maxRatio, ClientRect / baseWidth))
							if (tmpRatio !== ratio) {
								tmpRatio = ratio
								renderer.setPixelRatio(ratio)
								composer.setPixelRatio(ratio)
							}
						}
					}

					//モデルの更新
					const delta = clock.getDelta();
					const elapsedTime = clock.elapsedTime;
					for (const modelID in thisModel) {
						const model = thisModel[modelID];
						if (model.layerID === layerID) model.tick(delta, elapsedTime);
					}

					//レンダーの更新
					if (opacity.value == 1) {
						if (fadePass.enabled) fadePass.enabled = false
						zeroCount = 0

						if (passes.length < 3) {
							renderer.setRenderTarget(renderTarget);
							renderer.render(scene, camera);

							renderer.setRenderTarget(null);
							renderer.render(fadeScene, fadeCamera);

						} else {
							composer.render()
						}

					} else if (opacity.value !== 0 || zeroCount <= 30) {
						if (opacity.value !== 0) {
							zeroCount = 0
						} else {
							zeroCount++
						}

						if (passes.length < 3) {
							if (fadePass.enabled) fadePass.enabled = false
							renderer.setRenderTarget(renderTarget);
							renderer.render(scene, camera);

							renderer.setRenderTarget(null);
							renderer.render(fadeScene, fadeCamera);

						} else {
							if (!fadePass.enabled) fadePass.enabled = true
							composer.render()
						}
					}

					if (thisLayer.stats) thisLayer.stats.end();

				} else {
					//idが存在しない場合は処理を終了し、オブジェクトを削除する。
					VRoid.three.dispose(layerID)
				}
			}
			tick()
			
			if (showFPS) this.showFPS(layerID)
			
		},

		// VRoid.three.forceRenderUpdate("VRoid")
		forceRenderUpdate: function (layerID) {
			const thisLayer = this.layer[layerID]
		
			if (thisLayer.composer.passes.length < 3) {
				thisLayer.renderer.setRenderTarget(thisLayer.renderTarget);
				thisLayer.renderer.render(thisLayer.scene, thisLayer.camera);

				thisLayer.renderer.setRenderTarget(null);
				thisLayer.renderer.render(thisLayer.fadeScene, thisLayer.fadeCamera);

			} else {
				thisLayer.composer.render()
			}
		},

		light: function (pm, cb) {

			const {
				layerID,
				r,
				g,
				b,
				x,
				y,
				z,
				val,
				time = 0,
				wait = true,
				skip = false,
				easing = "default",
			} = pm;

			const thisLayer = this.layer[layerID];
			
			if (thisLayer === undefined) {
				//そんなレイヤーは存在しない
				if (cb && typeof cb === 'function') cb()
				return
			}
			
			const light = thisLayer.light


			//開始時の状態を保存
			const startVal = {
				r: light.color.r,
				g: light.color.g,
				b: light.color.b,
				x: light.position.x,
				y: light.position.y,
				z: light.position.z,
				val: light.intensity !== 0 ? light.intensity / Math.PI : 0,
			}

			//セーブデータ
			const tStat = TYRANO.kag.stat
			const saveLayer = tStat.VRoid.layer[layerID];
			const saveData = saveLayer.light

			//終了時の状態を保存
			const endVal = {
				r: createTarget(r, saveData.r || 1),
				g: createTarget(g, saveData.g || 1),
				b: createTarget(b, saveData.b || 1),
				x: createTarget(x, saveData.x || 0),
				y: createTarget(y, saveData.y || 0),
				z: createTarget(z, saveData.z || 0),
				val: createTarget(val, saveData.val || 1),
			}

			//セーブデータに保存
			for (const key in endVal) {
				saveData[key] = endVal[key]
			}
			saveData.layerID = layerID

			cancelAnimationFrame(thisLayer.lightTickID)
			const easingFunc = this.easing[easing];
			const startTime = performance.now();

			const tick = (timestamp) => {
				const elapsedTime = timestamp - startTime;

				let progress
				if (time !== 0) {
					progress = Math.max(0, Math.min(elapsedTime / time, 1))
				} else {
					progress = 1
				}

				//スキップが有効の場合は割り込み処理
				if (skip && tStat.is_skip) progress = 1
				
				const value = easingFunc(progress);

				const valR = startVal.r + (endVal.r - startVal.r) * value
				const valG = startVal.g + (endVal.g - startVal.g) * value
				const valB = startVal.b + (endVal.b - startVal.b) * value
				light.color.set(valR, valG, valB)

				light.position.set (
					startVal.x + (endVal.x - startVal.x) * value,
					startVal.y + (endVal.y - startVal.y) * value,
					startVal.z + (endVal.z - startVal.z) * value
				)

				const intensityVal = startVal.val + (endVal.val - startVal.val) * value
				light.intensity = intensityVal * Math.PI

				//髪のハイライト処理
				for (const modelID in this.model) {
					const model = this.model[modelID]
					if (model.vrm && model.layerID === layerID) {
						model.vrm.scene.traverse((obj) => {
							if (obj.isMesh && obj.material && obj.name.includes('Hair')) {
								obj.material.emissiveIntensity = intensityVal * saveLayer.highLight * Math.PI
							}
						});
					}
				}

				//追加したメッシュの色合い変更
				for (const key in this.img) {
					const mesh = this.img[key]
					if (mesh.layerID === layerID) {
						mesh.material.color.r = valR * intensityVal
						mesh.material.color.g = valG * intensityVal
						mesh.material.color.b = valB * intensityVal
					}
				}

				if (progress < 1) {
					thisLayer.lightTickID = requestAnimationFrame(tick);
				} else {
					if (cb && typeof cb === 'function' && wait) cb()
				}
			};
			tick(startTime);

			//waitがfalseの時は即NextOrder
			if (cb && typeof cb === 'function' && !wait) cb()


			function createTarget(value, initialVal) {
				//ないものはない
				if (initialVal === undefined) return undefined
				
				//変更する値がない場合は現在値(セーブ値)を返す
				if (value === undefined) return initialVal
			
				//先頭2文字を取得
				const str = String(value).slice(0, 2);
				const tmpVal = Number(String(value).slice(2))
				let endVal;

				if (str == "+=") {
					endVal = initialVal + tmpVal
				} else if (str == "-=") {
					endVal = initialVal - tmpVal
				} else if (str == "*=") {
					endVal = initialVal * tmpVal
				} else if (str == "/=") {
					//0除算回避
					if ( tmpVal !== 0 ) {
						targetVal = initialVal / tmpVal
					} else {
						targetVal = 0
					}
				} else if (str == "%=") {
					endVal = initialVal % tmpVal
				} else {
					//いずれでもない場合は数字のはず
					endVal = Number(value)
				}
				
				return endVal;
			}
		},

		// jsonのimport カンマ区切りで複数一気に読み込める
		// VRoid.three.import("sample.json", null, "_emotion")
		// VRoid.three.import("usamimi.json", null, "_pose")
		// VRoid.three.import("usamimi2.json", null, "_pose")
		import: function (storage, cb, property) {
			const storageArr = storage.split(',');
			const promises = [];
			
			const emotionObj = this.emotionObj
			const poseJson = this.poseJson
			const animEmoJson = this.animEmo

			storageArr.forEach(function(file) {
				file = file.trim();

				// 先頭が./なら削除
				if (file.startsWith("./")) {
					file = file.substring(2);
				}

				// 拡張子を削除してnameにする
				let name;
				const dotIndex = file.lastIndexOf(".");

				// .以降を削除
				if (dotIndex >= 0) {
					name = file.substring(0, dotIndex);
				} else {
					name = file;
				}

				const promise = new Promise(function(resolve, reject) {
					$.getJSON("./data/others/plugin/vrm/" + property + "/" + file).done(function(json) {

						if (property == "_emotion") {
							//表情データの追加
							const expressions = Object.keys(json).map(key => ({
								expressionName: key,
								val: json[key]
							}));

							emotionObj[name] = expressions;

						} if (property == "_pose") {
							//ポーズデータの追加
							//お手軽ポーズのバージョンによってインポート処理を変更する
							if (json.pose) {
								poseJson[name] = json.pose;
								Object.keys(poseJson[name]).forEach((key) => {
									if (poseJson[name][key].rotation) {
										poseJson[name][key].rotation[0] = poseJson[name][key].rotation[0] * (-1)
										poseJson[name][key].rotation[2] = poseJson[name][key].rotation[2] * (-1)
									}
								});
							} else {
								poseJson[name] = json;
							}
							//かけてるパーツがある場合は初期値で補完
							Object.keys(VRMHumanBoneList).forEach((key) => {
								const parts = VRMHumanBoneList[key]
								if (!poseJson[name][parts]) {
									poseJson[name][parts] = {rotation: [0, 0, 0, 1]}
								}
							});
							
							/*
							//デバッグ比較用
							function sortObjectKeys(obj) {
								// オブジェクトのキーをソート
								const sortedKeys = Object.keys(obj).sort();
							    
								// ソートされたキー順に新しいオブジェクトを作成
								const sortedObj = {};
								sortedKeys.forEach(key => {
									sortedObj[key] = obj[key];
								});
							    
								return sortedObj;
							}
							console.log(JSON.stringify(sortObjectKeys(poseJson[name])))
							*/
						} if (property == "_animEmo") {
							//アニメーション用タイムラインを追加
							const timeline = Object.keys(json).map(key => ({
								expressionName: key,
								val: json[key]
							}));

							animEmoJson[name] = json;
						
						}

						resolve();
					}).fail(function(err) { 
						VRoid.three.error(storage + " ファイルが存在しないか、jsonファイルの記述が間違っています。", err);
						resolve();
					});
				});

				promises.push(promise);
			});

			// 全ての処理が終了後にnextorder
			Promise.all(promises).then(function() {
				const statVRoid = TYRANO.kag.stat.VRoid;

				if (property == "_emotion") {
					//表情データのセーブ
					statVRoid["emotionObj"] = $.extend(true,{}, emotionObj);

				} if (property == "_pose") {
					//ポーズデータのセーブ
					statVRoid["poseJson"] = $.extend(true,{}, poseJson);

				} if (property == "_animEmo") {
					//ポーズデータのセーブ
					statVRoid["_animEmo"] = $.extend(true,{}, animEmoJson);

				}
				if (cb && typeof cb === 'function') cb()
			});
		},


		//ロード時の設定やレイヤー復元
		statLoad: function (cb) {
			const statVRoid = TYRANO.kag.stat.VRoid;

			if (statVRoid.emotionObj) {
				this.emotionObj = $.extend(true,{}, statVRoid.emotionObj);
			}
			
			if (statVRoid.poseJson) {
				this.poseJson = $.extend(true,{}, statVRoid.poseJson);
			}

			if (statVRoid.anim) {
				statVRoid.anim.forEach(function(storage) {
					VRoid.three.importAnimation(storage)
				});
			}


			//VRoidCanvasLayerを全部削除する
			const canvasLayer = document.getElementsByClassName("VRoidCanvasLayer");
			const arr = Array.from(canvasLayer);

			arr.forEach(function(elem) {
				elem.parentNode.removeChild(elem);
			});
			
			//moduleのロード
			for (const key in statVRoid.module) {
				this.importModule("import", [key])
			}

			// モデルをロードしてから復元する
			if (statVRoid) {

				this.layer = {}
				this.model = {}
				this.img = {}

				// レイヤーの復元
				const layerPromises = Object.entries(statVRoid.layer).map(([layerID, saveLayer]) => {
					return new Promise((resolve) => {
						this.create(saveLayer);

						//ライトの復元
						this.light(saveLayer.light)

						//カメラ設定の復元
						this.move(saveLayer);

						//レイヤーに表示するメッシュの復元
						for (const key in statVRoid.img) {
							const saveImg = statVRoid.img[key]
							if (saveImg.layerID === layerID) {
								this.add_img(saveImg)
							}
						}
						
						//エフェクトをかけた順番に復元
						if (saveLayer.effect) {
							const tmpEffect = saveLayer.effect.concat();
							tmpEffect.forEach((number) => {
								this.effect(layerID, number.name, number.option)
							});
						}

						resolve();
					});
				});

				// レイヤーの復元が終わるまで待つ
				Promise.all(layerPromises).then(() => {
					// モデルをロードしてからシーンの復元をする
					const modelPromises = Object.entries(statVRoid.model).map(([modelID, modelData]) => {
						return new Promise((resolve) => {
							this.load(modelID, modelData.file, () => {
								loadVRoid(modelID);
								resolve();
							}, true);
						});
					});

					// モデルの復元が終わるまで待つ
					Promise.all(modelPromises).then(() => {
						if (cb && typeof cb === 'function') cb()
					});
				});
			}

			const that = this;
			
			function loadVRoid (modelID) {
				//シーンの復元
				const saveModel = TYRANO.kag.stat.VRoid.model[modelID];
				const vrm = that.model[modelID].vrm;

				if (saveModel.layerID) {
					// シーンへの追加
					that.add(saveModel)

					//モデルシーンの復元(addに統合)
					//that.move(saveModel)

					//表情の復元
					// 各ブレンドシェイプを適用
					if (saveModel.expression) {
						saveModel.expression.forEach(function (data) {
							let expressionName = data.expressionName;
							let currentValue = data.val;

							vrm.expressionManager.setValue(expressionName, currentValue);
						});
					}

					vrm.expressionManager.update();

					//LOOP状態のactionの復元
					if (saveModel.mixer && !saveModel.mixer.keep) {
						//ループの場合はこちらから表情復元
						vrm.expressionManager.resetValues()
						if (saveModel.mixer.expression) {
							saveModel.mixer.expression.forEach(function (data) {
								let expressionName = data.expressionName;
								let currentValue = data.val;

								vrm.expressionManager.setValue(expressionName, currentValue);
							});
						} else {
							//存在しない場合はリセット
							delete saveModel.expression
						}
						that.animation(modelID, saveModel.mixer.storage, saveModel.mixer.rate, 0, saveModel.mixer.fadeIn, saveModel.mixer.fadeOut, false, false, null, saveModel.mixer.type, false, saveModel.mixer.duration, saveModel.mixer.endTime, saveModel.mixer.emoTimeline)
					}
					
					//KEEP状態のactionの復元
					if (saveModel.mixer && saveModel.mixer.keep) that.animation(modelID, saveModel.mixer.storage, 1, 1, 0, 0, true, true, null, saveModel.mixer.type, true, saveModel.mixer.duration, saveModel.mixer.endTime)
				}
			}

		},


		//表示レイヤーの破棄
		// VRoid.three.dispose("VRoid")
		dispose: function (layerID) {
		
			if (!this.layer[layerID]) {
				if (document.getElementById(layerID)) {
					document.getElementById(layerID).remove();
				}
				return
			}
		
			const scene = this.layer[layerID].scene
			const renderer = this.layer[layerID].renderer
			const composer = this.layer[layerID].composer

			cancelAnimationFrame(this.layer[layerID].tickID)

			//レイヤーに読み込んでいるモデルを完全消去
			for (const key in this.model) {
				try {
					const modelID = this.model[key]
					if (modelID.layerID === layerID && modelID.vrm) {
						cancelAnimationFrame(modelID.tickID)
						scene.remove( modelID.vrm.scene );
						VRMUtils.deepDispose( modelID.vrm.scene );
						
						delete this.model[key]
					}
				} catch (e) {}
			}

			//レイヤーに読み込んでいるメッシュを完全消去
			for (const key in this.img) {
				try {
					const mesh = this.img[key]
					if (mesh.layerID === layerID) {
						cancelAnimationFrame(mesh.tickID)
						mesh.geometry.dispose();
						mesh.material.dispose();
						scene.remove( mesh );

						delete this.img[key]
					}
				} catch (e) {}
			}

			if (renderer) {
				renderer.dispose(); // WebGLRendererを破棄
				renderer.forceContextLoss(); // WebGLコンテキストを強制解放
			}
			if (composer) composer.dispose();
			
			//FPSカウンターがあれば削除
			if (document.getElementById(layerID + "statsPanel")) {
				document.getElementById(layerID + "statsPanel").remove();
			}

			//レイヤーオブジェクトを破棄
			delete this.layer[layerID];

			//セーブデータの破棄
			const statVRoid = TYRANO.kag.stat.VRoid;
			delete statVRoid.layer[layerID];

			//canvasの削除
			if (document.getElementById(layerID)) {
				document.getElementById(layerID).remove();
			}
		},

		//表示レイヤーの表示状態の変更
		// VRoid.three.layerAnime( {layerID:"VRoid", time:1000, visible: 1} )
		layerAnime: function (pm, cb) {

			const { 
				layerID,
				time = 0,
				wait = true,
				skip = false,
				easing = "default",
				visible = 1,			//1でfadeIn 0でfadeOut
			} = pm;

			//IDの確認。なければ即終了
			if (!document.getElementById(layerID)) {
				if (cb && typeof cb === 'function') cb()
				return
			}

			//表示状態の保存
			const tStat = TYRANO.kag.stat
			const saveLayer = tStat.VRoid.layer[layerID];
			saveLayer.visible = visible;

			const thisLayer = this.layer[layerID];
			const opacity = thisLayer.fadePass.uniforms.opacity

			cancelAnimationFrame(thisLayer.layerAnimeTickID)
			const easingFunc = this.easing[easing];
			const startTime = performance.now();

			const fadeIn = (timestamp) => {
				const elapsedTime = timestamp - startTime;

				let progress
				if (time !== 0) {
					progress = Math.max(0, Math.min(elapsedTime / time, 1))
				} else {
					progress = 1
				}

				//スキップが有効の場合は割り込み処理
				if (skip && tStat.is_skip) progress = 1

				opacity.value = easingFunc(progress);

				if (progress < 1) {
					thisLayer.layerAnimeTickID = requestAnimationFrame(fadeIn);
				} else {
					if (cb && typeof cb === 'function' && wait) cb()
				}
			};

			const fadeOut = (timestamp) => {
				const elapsedTime = timestamp - startTime;

				let progress
				if (time !== 0) {
					progress = Math.max(0, Math.min(elapsedTime / time, 1))
				} else {
					progress = 1
				}

				//スキップが有効の場合は割り込み処理
				if (skip && tStat.is_skip) progress = 1

				opacity.value = 1 - easingFunc(progress);

				if (progress < 1) {
					thisLayer.layerAnimeTickID = requestAnimationFrame(fadeOut);
				} else {
					if (cb && typeof cb === 'function' && wait) cb()
				}
			};

			if (visible == 1) {
				fadeIn(startTime);
			} else {
				fadeOut(startTime);
			}

			//waitがfalseの時は即NextOrder
			if (cb && typeof cb === 'function' && !wait) cb()

		},

		
		//モデルのロード。
		// VRoid.three.load("model1", "./data/others/plugin/vrm/model/AliciaSolid.vrm")
		load: function (modelID, file, cb, wait, maker) {
			//waitのデフォルト値をセット
			if (wait === undefined) wait = true;

			if (this.model[modelID]) {
				this.error(id + " 同一IDのキャラクターは作成できません。")
				if (cb && typeof cb === 'function') cb()
				return
			}
			
			//モデル用セーブデータオブジェクト
			const statVRoid = TYRANO.kag.stat.VRoid;
			if (!statVRoid.model[modelID]) {
				statVRoid.model[modelID] = {};
			}
			const saveModel = statVRoid.model[modelID];
			saveModel.file = file;

			this.model[modelID] = {};
			
			const loader = new GLTFLoader();
			loader.crossOrigin = 'anonymous';
			loader.register((parser) => {
				return new VRMLoaderPlugin(parser, { autoUpdateHumanBones: true } );
			});

			loader.load(

				// URL of the VRM you want to load
				file,

				// called when the resource is loaded
				(gltf) => {

					const model = this.model[modelID]
					model.modelID = modelID
					model.vrm = gltf.userData.vrm;
					const vrm = model.vrm

					VRMUtils.removeUnnecessaryVertices( gltf.scene );
					//VRMUtils.removeUnnecessaryJoints( gltf.scene );
					VRMUtils.combineSkeletons( gltf.scene ); // introduced in v3.2.0
					//下を実行すると表情データの取得ができなくなる
					//VRMUtils.combineMorphs( vrm ); // introduces in v3.3.0
					VRMUtils.rotateVRM0(vrm);

					//Y軸の補正を保存
					model.correctionRotateY = vrm.scene.rotation.y

					vrm.scene.traverse( ( obj ) => {
						obj.frustumCulled = false;

						//透過マテリアルの減色回避
						if (obj.isMesh && obj.material && obj.material.map) {
							obj.material.map.minFilter = THREE.LinearFilter;
							obj.material.map.magFilter = THREE.LinearFilter;
							//console.log(obj.material.premultipliedAlpha)
//if (obj.material.premultipliedAlpha === false) obj.material.premultipliedAlpha = true

/*
							if (obj.material.onBeforeCompile) {

								const material = obj.material

const originalOnBeforeCompile = material.onBeforeCompile;
material.onBeforeCompile = (shader) => {

        shader.fragmentShader = shader.fragmentShader.replace(
          `#include <alphatest_fragment>`,
          `#include <alphatest_fragment>
           diffuseColor.a = sRGBTransferOETF(vec4(0.0, 0.0, 0.0, diffuseColor.a)).a * 0.8;`
        )
        material.userData.shader = shader
  originalOnBeforeCompile(shader);


};

material.needsUpdate = true;

							}
*/


						}
					});

					//morphTargetDictionaryから表情データを取得
					function findAllKeys(obj, fName, parentKey = '', seen = new Set()) {
						let keys = [];
						for (let key in obj) {
							const fullPath = parentKey ? `${parentKey}.${key}` : key;
							if (key === fName) {
								keys.push(obj[key]);
							}
							if (typeof obj[key] === 'object' && obj[key] !== null && !seen.has(obj[key])) {
								seen.add(obj[key]);
								keys = keys.concat(findAllKeys(obj[key], fName, fullPath, seen));
							}
						}
						return keys;
					}

					const primitives = findAllKeys(vrm.expressionManager._expressions, "primitives");

					let tmp
					tmp = []
					primitives.forEach((child) => {
							
						child.forEach((data) => {
							if (data.morphTargetDictionary) {
								for (const key in data.morphTargetDictionary) {
									if (tmp.indexOf(key) === -1) {
										tmp.push(key)

										const addExpression = new VRMExpression(key);
										addExpression.addBind(new VRMExpressionMorphTargetBind({index: data.morphTargetDictionary[key], primitives: child, weight: 1}));
										
										vrm.expressionManager._expressionMap[key] = addExpression;
										vrm.expressionManager._expressions.push(addExpression);
										
										//追加でこれが使えるようになる。
										//console.log(key)
									}
								}
							}
						});
					});
					//delete tmp
					tmp = undefined;
					//debugが有効ならemoMakerを立ち上げる
					if (maker) this.emoMaker(modelID)
					
					//風の為に揺れ物のデフォルト値を取得
					model.wind = {default:[]}
					const wind = model.wind

					//揺れ物のデフォルト値を取得
					vrm.springBoneManager._objectSpringBonesMap.forEach(element => {
						element.forEach((node) => {
							wind.default.push({
								gravityDir: node.settings.gravityDir,
								gravityPower: node.settings.gravityPower
							});
						});
					});

					/*
					console.log(vrm.meta.metaVersion)
					if (vrm.meta.metaVersion === '0') {
						// vrm.meta: VRM0Meta
					} else if (vrm.meta.metaVersion === '1') {
						// vrm.meta: VRM1Meta
					}
					*/

					//if (cb && typeof cb === 'function' && wait) cb()
					//setTimeoutで呼び出さないと後続のコードのエラーまでcatchしてしまう
					if (cb && typeof cb === 'function' && wait) setTimeout(cb, 0)
					
				},
				// called while loading is progressing
				(progress) => {
					//console.log('Loading model...', 100.0 * (progress.loaded / progress.total), '%')
				},

				// called when loading has errors
				(error) => {
					VRoid.three.error("モデルデータのロード時にエラーが発生しました。")
					if (cb && typeof cb === 'function' && wait) cb()
				}
			)

			//waitがfalseの時は即NextOrder
			if (cb && typeof cb === 'function' && !wait) cb()
		},

		//待機モーションのアップデート
		updateWaitingAnimation: function (humanoid, waitingAnimationVal, s) {
			humanoid.getNormalizedBoneNode(VRMHumanBoneName.Neck).rotation.x          = s + waitingAnimationVal.Neck
			humanoid.getNormalizedBoneNode(VRMHumanBoneName.Chest).rotation.x         = s + waitingAnimationVal.Chest
			humanoid.getNormalizedBoneNode(VRMHumanBoneName.RightShoulder).rotation.z = s + waitingAnimationVal.RightShoulder
			humanoid.getNormalizedBoneNode(VRMHumanBoneName.LeftUpperArm).rotation.z  = s + waitingAnimationVal.LeftUpperArm

			humanoid.getNormalizedBoneNode(VRMHumanBoneName.Spine).rotation.x         = (-1 * s) + waitingAnimationVal.Spine
			humanoid.getNormalizedBoneNode(VRMHumanBoneName.RightUpperArm).rotation.z = (-1 * s) + waitingAnimationVal.RightUpperArm
			humanoid.getNormalizedBoneNode(VRMHumanBoneName.LeftShoulder).rotation.z  = (-1 * s) + waitingAnimationVal.LeftShoulder
		},
		
		//待機モーションの基準位置を保存する
		saveWaitingAnimationVal: function (humanoid, model) {
			model.waitingAnimationVal = {
				Neck          : humanoid.getNormalizedBoneNode(VRMHumanBoneName.Neck).rotation.x,
				Chest         : humanoid.getNormalizedBoneNode(VRMHumanBoneName.Chest).rotation.x,
				Spine         : humanoid.getNormalizedBoneNode(VRMHumanBoneName.Spine).rotation.x,
				RightShoulder : humanoid.getNormalizedBoneNode(VRMHumanBoneName.RightShoulder).rotation.z,
				RightUpperArm : humanoid.getNormalizedBoneNode(VRMHumanBoneName.RightUpperArm).rotation.z,
				LeftShoulder  : humanoid.getNormalizedBoneNode(VRMHumanBoneName.LeftShoulder).rotation.z,
				LeftUpperArm  : humanoid.getNormalizedBoneNode(VRMHumanBoneName.LeftUpperArm).rotation.z
			};
		},

		//ブリンク処理
		runBlink: function (vrm, model, val) {
			//まばたき追加 表情変更中は動かさない
			if (model.isEmotion !== true) {
				let bName = "blink"
				let bInvalid = ""
				let minVal = 0
				let invalidVal = 0
				const modelID = model.modelID

				//blinkDataの条件を検索
				const blinkData = TYRANO.kag.stat.VRoid.model[modelID].blinkData
				const expression = TYRANO.kag.stat.VRoid.model[modelID].expression
				blinkTable : for (let data in blinkData) {
					for (let key in expression) {
						if (data == expression[key].expressionName && expression[key].val > 0) {
							bName = blinkData[data].set;
							bInvalid = blinkData[data].invalid;
							break blinkTable;
						}
					}
				}

				//ブリンクするデータの現在の値を取得
				for (let key in expression) {
					if (bName == expression[key].expressionName) {
						minVal = expression[key].val;
					}
				
					//ブリンク中0にする値
					if (bInvalid !== "" && bInvalid == expression[key].expressionName) {
						invalidVal = expression[key].val;
					}
				}

				let bVal = val
				if (bVal <= 0.01) {
					bVal = 0
				} else {
					invalidVal = invalidVal * (1 - bVal)
				}
				
				//model.noBlinkがtrueの時はbValが0になるまでブリンクさせない
				if (model.noBlink && bVal == 0) {
					model.noBlink = false
				} else if (model.noBlink && bVal > 0) {
					bName = ""
				}
				
				model.isBlink = bVal > 0 //値が0以上になっている場合はブリンク中判定
				
				//bNameが空白でなければブリンクを実行
				if (bName !== "") {
					vrm.expressionManager.setValue(bName, Math.max(bVal, minVal))
					if (bInvalid) vrm.expressionManager.setValue(bInvalid, invalidVal)
					
				}
			} else {
				model.noBlink = true
			}
		},

		//モデルの追加
		// VRoid.three.add("vroidID", "model1")
		add: function (pm) {

			const {
				layerID,
				modelID,
				
				pose = "default",
				visible = true,

				x = 0,
				y = 0,
				z = 0,
				rotX = 0,
				rotY = 0,
				rotZ = 0,
				scaleX = 1,
				scaleY = 1,
				scaleZ = 1,

				firstShake = false,
				lookingCamera = false,
				waitingAnimation = true,
				shake = true,
				waitingAnimationVal = 15,
				shakeSpeed = 1,
				waitingAnimationSpeed = 1,

			} = pm;

			const model = this.model[modelID]
			const vrm = model.vrm
			const thisLayer = this.layer[layerID]
			const scene = thisLayer.scene
			const camera = thisLayer.camera

			if (model.layerID) {
				this.error(modelID + " 既に追加済みのIDのキャラクターは追加できません")
				return
			}

			model.layerID = layerID
			model.isAnimating = false;
			
			//目線変更用オブジェクト
			model.lookAtTarget = new THREE.Object3D()
			vrm.scene.add(model.lookAtTarget);

			//セーブデータ用
			const statVRoid = TYRANO.kag.stat.VRoid;
			const saveLayer = statVRoid.layer[layerID];
			
			pm.type = "model"
			const saveModel = statVRoid.model[modelID];

			//セーブデータに保存
			for (const key in pm) {
				saveModel[key] = pm[key]
			}


			//一度カメラ外で描画する
			const tmpZ = (saveLayer.far * 10) || 10000
			vrm.scene.position.z = tmpZ
			vrm.update( 10000 );
			scene.add(vrm.scene);

			//WebGL2を有効にすると、ここのレンダリングに時間がかかる r173に上げると倍くらい掛かる
			//console.time('initial render');
			thisLayer.renderer.render(scene, camera)
			thisLayer.composer.render()
			//console.timeEnd('initial render');

			vrm.scene.position.z = 0
			for (let i = 0; i < 5; i++) {
				vrm.update(10000);
			}



			//髪のハイライトのギラつきを抑える対応
			vrm.scene.traverse((obj) => {
				if (obj.isMesh && obj.material && obj.name.includes('Hair')) {
					obj.material.emissiveIntensity = saveLayer.highLight * thisLayer.light.intensity
				}
			});

			if (!saveModel.material) {
				//初期読み込み時にmaterial情報を取得（IDや配列準が読み込むタイミングで変わる為）
				this.initializeMaterial(modelID)
			} else {
				//データがあるときは状態をロード
				this.loadMaterial(modelID)
			}

			if (!saveModel.wind) {
				saveModel.wind = {
					enable: false,
					val: 0.5,
					speed: 1,
					x: 1,
					y: 0,
					z: 0,
					rotX: this.layer[model.layerID].camera.rotation.x,
					rotY: this.layer[model.layerID].camera.rotation.y,
					rotZ: this.layer[model.layerID].camera.rotation.z,
					excl: "Bust",
					min: 0.5,
				}
			} else {
				//Ver222追加対応。以前のデータ互換のためminは0に設定
				if (saveModel.wind.excl === undefined) saveModel.wind.excl = "Bust"
				if (saveModel.wind.min === undefined) saveModel.wind.min = 0
			}
			

			if (!saveModel.lipSync) {
				saveModel.lipSync = {
					isSync: false,
					buf: null,
					micVolume: 2,
					micMinLevel: 0,
					micMix: 0.75,
					fadeOut: 500,
					invalidList: ["aa", "ih", "ou", "ee", "oh"],
					lipData: {
						aa: 1,
						ih: 0,
						ou: 0,
						ee: 0,
						oh: 0,
					}
				}
			}
			//V240追加
			if (!saveModel.lipSync.isSyncPos) saveModel.lipSync.isSyncPos = false
			if (!saveModel.lipSync.posRate) saveModel.lipSync.posRate = 3

			//まばたき設定
			if (!saveModel.blinkData) {
				saveModel.blinkData = {
					"blinkLeft": {"set": "blinkRight", "invalid":""},
					"blinkRight": {"set": "blinkLeft", "invalid":""},
					"happy": {"set": "happy", "invalid":""},
				}
			}

			if (!saveModel.blink) {
				saveModel.blink = {
					enable: true,
					stroke: 1,
					speed: 1,
				}
			}

			vrm.scene.position.set(x, y, z)
			vrm.scene.rotation.set(rotX, rotY + model.correctionRotateY, rotZ)
			vrm.scene.scale.set(scaleX, scaleY, scaleZ)

			vrm.scene.visible = visible;
			vrm.scene.name = modelID;

			//カメラ目線
			vrm.lookAt.autoUpdate = true;
			if (lookingCamera) {
				vrm.lookAt.target = camera;
			} else if (saveModel.lookAtTarget) {
				//目線データがある場合は復元する
				this.loadLookAt(modelID);
			}

			//初期ポーズの設定
			if (pose) {
				if (this.poseJson[pose]) {
					const poseJson = this.poseJson[pose]
					vrm.humanoid.setNormalizedPose(this.poseCorrection(poseJson, vrm))
				} else {
					this.error(pose + " に設定されたポーズデータがありません。")
				}
			}

			vrm.update( 0.0001 );

			//待機モーションの設定
			this.saveWaitingAnimationVal(vrm.humanoid, model)
			
			this.makeModelTick(modelID)

			//モデル追加時の揺れを抑制する処理
			if (!firstShake) {
				for (let i = 0; i < 5; i++) {
					vrm.update(10000);
				}
			}

		},

		//モデルの更新処理作成
		makeModelTick: function (modelID) {
			const that = VRoid.three
			
			const model = this.model[modelID]
			const vrm = model.vrm

			const tStat = TYRANO.kag.stat
			const saveModel = tStat.VRoid.model[modelID];

			model.waitingClock = new THREE.Clock();

			let windEnd = false
			const vec = new THREE.Vector3();
			const euler = new THREE.Euler();

			model.tick = function (delta, elapsedTime) {

				if ( vrm ) {
					if ( model.mixer && model.mixer.action && model.mixer.action.enabled) {
						model.mixer.update( delta );
						
						//タイムラインがある場合は実行
						const timeline = model.mixer.action.emoTimeline
						if (timeline) {
							const nowTime = model.mixer.action.time
							for (const key in timeline) {
								//開始時間より先のタイムラインを実行する
								const keyTime = key * 0.001
								if (keyTime >= model.mixer.action.startTime && keyTime <= nowTime && !timeline[key].isDone) {
									timeline[key].isDone = true
									that.emotion(modelID, timeline[key].emo, Number(timeline[key].time), timeline[key].easing, null, false, false, timeline[key].diff === "true", timeline[key].emoID, timeline[key].emoval)
									break
								}
							}
						}
						
						//終了時間が設定されている場合は停止処理
						if (model.mixer.action.endTime && model.mixer.action.endTime <= model.mixer.action.time) {
							if (!model.mixer.action.paused) {
								model.mixer.dispatchEvent({ type: 'finished', action: model.mixer.action });
							}
						}
					} else {
						//待機モーション ポーズの変更時は止める
						if (!model.isAnimating && saveModel.waitingAnimation) {
							//waitingValの数字を大きくすると待機モーションの動きが大きくなる
							const waitingVal = saveModel.waitingAnimationVal * 0.001;
							model.waitingClock.getDelta();
							that.updateWaitingAnimation(vrm.humanoid, model.waitingAnimationVal, waitingVal * (Math.sin( Math.PI * (model.waitingClock.elapsedTime * saveModel.waitingAnimationSpeed))))
						}
					}
					
					//風処理
					if (saveModel.wind.enable) {
						const saveWind = saveModel.wind
						if (saveWind.min === undefined) saveWind.min = 0.5
						vec.set(saveWind.x, saveWind.y, saveWind.z);
						euler.set(saveWind.rotX, saveWind.rotY, saveWind.rotZ, "XYZ");
						vec.applyEuler(euler);

						vrm.springBoneManager._objectSpringBonesMap.forEach(element => {
							element.forEach(node => {
								//指定されたボーンを除外して風をあてる
								if (!saveWind.exclList.some(exclude => node.bone.name.includes(exclude))) {
									let currentGravity = node.settings.gravityDir.clone();
									currentGravity.add(vec);

									const minRatio = saveWind.min; // 最低値の割合
									const minValue = saveWind.val * minRatio; // 最小値
									const amplitude = saveWind.val - minValue; // 振幅


									node.settings.gravityDir = currentGravity.normalize();
									node.settings.gravityPower = minValue + amplitude * Math.abs(Math.sin(Math.PI * (elapsedTime * saveWind.speed)));
									//node.settings.gravityPower = Math.abs(saveWind.val * (Math.sin( Math.PI * (elapsedTime * saveWind.speed))));
								}
							});
						});
						windEnd = false

					} else {
						if (!windEnd) {
							let i = 0
							vrm.springBoneManager._objectSpringBonesMap.forEach(element => {
								element.forEach(node => {
									node.settings.gravityDir = model.wind.default[i].gravityDir;
									node.settings.gravityPower = model.wind.default[i].gravityPower;
								});
								i++
							});
							windEnd = true
						}
					}

					//またばき処理 まばたき中に無効化してもストロークが終わるまでは処理
					const blink = saveModel.blink
					if (blink.enable || model.isBlink) {
						const bStroke = blink.stroke
						const bSpeed = blink.speed * 1024
						that.runBlink(vrm, model, Math.sin(elapsedTime * 1/ (3 * bStroke)) ** (bSpeed * bStroke)) + (Math.sin(elapsedTime * 4/ (7 * bStroke)) ** (bSpeed * bStroke))
					}

					if (saveModel.shake && !tStat.is_skip) {
						//saveModel.shakeSpeedの小さい数字ほど揺れ物の揺れが遅くなる
						vrm.update( delta * saveModel.shakeSpeed );
					} else {
						//大きな数字を渡して実質揺れないようにする。動きが激しいと多少は揺れる
						//スキップ中も揺れない
						vrm.update( 10000 );
					}

				}
			}
			
		},

		//シーンに追加したモデルを削除
		// VRoid.three.delete("VRoid", "model1")
		delete: function (modelID) {

			const model = this.model[modelID]
			const vrm = model.vrm

			//セーブデータ用
			const statVRoid = TYRANO.kag.stat.VRoid;
			const saveModel = statVRoid.model[modelID];

			const scene = this.layer[saveModel.layerID].scene

			delete saveModel.layerID


			//action関係の削除
			$(model.mixer).off();
			delete saveModel.mixer

			scene.remove(vrm.scene);

		},
		
		//モデルの設定変更
		modelConfig: function (modelID, lookingCamera, shake, shakeSpeed, waitingAnimation, waitingAnimationVal, waitingAnimationSpeed) {
			const model = this.model[modelID]
			const vrm = this.model[modelID].vrm
			const statVRoid = TYRANO.kag.stat.VRoid;
			const saveModel = statVRoid.model[modelID];
			
			let camera
			if (model.layerID) {
				camera = this.layer[model.layerID].camera
			}

			if (lookingCamera !== undefined && lookingCamera !== null) {
				saveModel.lookingCamera = lookingCamera
				cancelAnimationFrame(model.requestlookAtId)
				if (camera) {
					if (lookingCamera) {
						vrm.lookAt.target = camera;
						delete saveModel.lookAtTarget;
					} else {
						delete vrm.lookAt.target
						vrm.lookAt.reset()
					}
				}
			}

			if (shake !== undefined && shake !== null) {
				saveModel.shake = shake
			}

			if (shakeSpeed !== undefined && shakeSpeed !== null) {
				saveModel.shakeSpeed = shakeSpeed
			}
			
			if (waitingAnimation !== undefined && waitingAnimation !== null) {
				saveModel.waitingAnimation = waitingAnimation
			}
			
			if (waitingAnimationVal !== undefined && waitingAnimationVal !== null) {
				saveModel.waitingAnimationVal = waitingAnimationVal
			}

			if (waitingAnimationSpeed !== undefined && waitingAnimationSpeed !== null) {
				saveModel.waitingAnimationSpeed = waitingAnimationSpeed
			}
			
		},

		//モデルの表示
		// VRoid.three.show("model1")
		show: function (modelID, time, func, cb, wait) {
			this.model[modelID].vrm.scene.visible = true;

			//セーブデータ用
			const statVRoid = TYRANO.kag.stat.VRoid;
			const saveModel = statVRoid.model[modelID];
			saveModel.visible = true

			if (cb && typeof cb === 'function') cb()

		},

		//モデルの非表示
		// VRoid.three.hide("model1", time, func, cb, wait)
		hide: function (modelID, time, func, cb, wait) {
			this.model[modelID].vrm.scene.visible = false;

			//セーブデータ用
			const statVRoid = TYRANO.kag.stat.VRoid;
			const saveModel = statVRoid.model[modelID];
			saveModel.visible = false

			if (cb && typeof cb === 'function') cb()

		},

		//マテリアルの表示設定
		material: function (modelID, materialID, visible, outline) {
			//セーブデータ用
			const statVRoid = TYRANO.kag.stat.VRoid;
			const saveModel = statVRoid.model[modelID];
			
			const materials = this.model[modelID].vrm.materials

			if (materialID != null) {
				const materialArr = materialID.split(',');

				materialArr.forEach(function(ID) {
					ID = ID.trim();

					//materialIDからnameを取得
					let name
					for (const key in saveModel.material) {
						if (saveModel.material[key].id == ID) name = key
					}

					let outlineName
					if (name) {
						outlineName = name + " (Outline)"
						for (const key in materials) {
							const mateName = materials[key].name
							if (name == mateName) {
								materials[key].visible = visible;
								saveModel.material[name].visible = visible;
							}
						}
					}

					//アウトラインも処理するかどうか
					//次のIDの名前の後ろに" (Outline)"を付けたものと一致した場合は処理する
					if (outline) {
						name = null
						const nextMaterialID = Number(ID) + 1
						for (const key in saveModel.material) {
							if (saveModel.material[key].id == nextMaterialID) name = key
						}

						if (name && outlineName == name) {
							for (const key in materials) {
								const mateName = materials[key].name
								if (name == mateName) {
									materials[key].visible = visible;
									saveModel.material[name].visible = visible;
								}
							}
						}
					}
				});

			} else {
				//materialIDの指定がない場合は全てに処理を実行
				for (const key in materials) {
					materials[key].visible = visible;
				}
				for (const key in saveModel.material) {
					saveModel.material[key].visible = visible;
				}

			}

		},
		
		//初回ロード時のmaterial情報取得処理
		initializeMaterial: function (modelID) {
			const statVRoid = TYRANO.kag.stat.VRoid;
			const saveModel = statVRoid.model[modelID];

			const materials = this.model[modelID].vrm.materials
			
			const tmp = []
			
			//重複がないように追加してソート
			for (const key in materials) {
				const name = materials[key].name;
				if (!tmp.includes(name)) tmp.push(name)
			}
			tmp.sort()
			
			//セーブデータの作成（初期状態は全て表示）
			saveModel.material = {}
			for (let i = 0; i < tmp.length; i++) {
				saveModel.material[tmp[i]] = {"id": i, "visible": true}
			}
		},
		
		//モデルのロード時（addのタイミング）に使用
		loadMaterial: function (modelID) {
			//セーブデータ用
			const statVRoid = TYRANO.kag.stat.VRoid;
			const saveModel = statVRoid.model[modelID];

			const materials = this.model[modelID].vrm.materials

			for (const saveName in saveModel.material) {
				for (const key in materials) {
					const name = materials[key].name

					if (name == saveName) {
						materials[key].visible = saveModel.material[saveName].visible;
						
						//テクスチャー画像の変更があった場合
						if (saveModel.material[saveName].storage) {
							this.changeTexture({modelID: modelID, materialID: saveModel.material[saveName].id, storage: saveModel.material[saveName].storage})
						}
						
						//テクスチャー色の変更があった場合
						if (saveModel.material[saveName].color) {
							const tmpPM = $.extend(true,{}, saveModel.material[saveName].color);
							tmpPM.modelID = modelID
							tmpPM.materialID = saveModel.material[saveName].id
							this.changeColor(tmpPM)
						}
					}
				}
			}
		},

		//vroid_maker ファイルドロップ用
		changeTextureBlob: async function (modelID, blob, name) {
			try {
				// Blob から Texture を生成
				const texture = await createTextureFromBlob(blob);

				const materials = this.model[modelID].vrm.materials

				let outlineName;
				if (name) {
					outlineName = name + " (Outline)";
					for (const key in materials) {
						const mateName = materials[key].name;
						if (name == mateName) {
							materials[key].map = texture;
							materials[key].shadeMultiplyTexture = texture;
						}
					}
				}

				// アウトライン処理
				if (name && outlineName) {
					for (const key in materials) {
						const mateName = materials[key].name;
						if (outlineName == mateName) {
							materials[key].map = texture;
							materials[key].shadeMultiplyTexture = texture;
						}
					}
				}
			} catch (error) {
				console.error("テクスチャのロードに失敗しました：", error);
			}

			async function createTextureFromBlob (blob) {
				return new Promise((resolve, reject) => {
					const reader = new FileReader();
					reader.onload = function (event) {
						const img = new Image();
						img.onload = function () {
							const texture = new THREE.Texture(img);
							texture.needsUpdate = true;
							texture.colorSpace = THREE.SRGBColorSpace;
							texture.minFilter = THREE.LinearFilter;
							texture.magFilter = THREE.LinearFilter;
							texture.flipY = false;
							texture.transparent = true;

							resolve(texture);
						};
						img.onerror = reject;
						img.src = event.target.result;
					};
					reader.onerror = reject;
					reader.readAsDataURL(blob);
				});
			}

		},


		//モデルに風をあてる 風が出る方向は実行時のカメラ基準
		// VRoid.three.wind("model1", 0.5, 1, 1, 0, 0)
		// VRoid.three.wind("model1", 0.1)
		wind: function (modelID, val, speed, x, y, z, excl, min) {
			//セーブデータ用
			const statVRoid = TYRANO.kag.stat.VRoid;
			const saveModel = statVRoid.model[modelID];
			const model = this.model[modelID]

			if (val !== undefined) saveModel.wind.val = Number(val)
			if (speed !== undefined) saveModel.wind.speed = Number(speed)
			if (x !== undefined) saveModel.wind.x = Number(x)
			if (y !== undefined) saveModel.wind.y = Number(y)
			if (z !== undefined) saveModel.wind.z = Number(z)
			if (excl !== undefined) saveModel.wind.excl = excl
			if (min !== undefined) saveModel.wind.min = Number(min)
			
			//指定された文字列を含むボーン名には風をあてない
			if (saveModel.wind.excl) {
				saveModel.wind.exclList = saveModel.wind.excl.split(",").map(str => str.trim())
			} else {
				saveModel.wind.exclList = []
			}

			saveModel.wind.rotX = this.layer[model.layerID].camera.rotation.x
			saveModel.wind.rotY = this.layer[model.layerID].camera.rotation.y
			saveModel.wind.rotZ = this.layer[model.layerID].camera.rotation.z
			saveModel.wind.enable = true

		},

		//風をとめる
		// VRoid.three.stopWind("model1")
		stopWind: function (modelID) {
			//セーブデータ用
			const statVRoid = TYRANO.kag.stat.VRoid;
			const saveModel = statVRoid.model[modelID];

			saveModel.wind.enable = false

		},
		poseCorrection: function (poseJson, vrm) {
			let cprrPose = $.extend(true,{}, poseJson);
		
			if (vrm.meta.metaVersion === '1') {
				Object.keys(poseJson).forEach((key) => {
					if (poseJson[key].rotation) {
						cprrPose[key].rotation[0] = poseJson[key].rotation[0] * (-1)
						cprrPose[key].rotation[2] = poseJson[key].rotation[2] * (-1)
					}
				});
			}
			//} else if (vrm.meta.metaVersion === '0') {}
			return cprrPose
		},
		
		//モデルのポージング
		// VRoid.three.pose("model1", "")
		pose: function (modelID, poseName, time, func, cb, wait, skip) {
			//waitのデフォルト値をセット
			if (wait === undefined) wait = true;

			const model = this.model[modelID]
			const vrm = this.model[modelID].vrm;
			const that = this;

			let initialValues = {};
			let targetValues = {};
			let requestId;
			let poseJson;
			
			if (!vrm) return
			
			const autoCamera = vrm.lookAt.target && vrm.lookAt.autoUpdate //カメラ目線が有効ならtrue 目線は変更させない
			
			if (this.poseJson[poseName]) {
				poseJson = $.extend(true,{}, this.poseJson[poseName]);
			} else {
				this.error(poseName + " に設定されたポーズデータがありません。")
				if (cb && typeof cb === 'function') cb()
				return;
			}
			
			//モデルのバージョンによってrotation補正
			poseJson = this.poseCorrection(poseJson, vrm)

			//セーブデータ用
			const tStat = TYRANO.kag.stat
			const statVRoid = tStat.VRoid;
			const saveModel = statVRoid.model[modelID];

			cancelAnimationFrame(model.poseRequestId)

			saveModel.pose = poseName

			//時間指定がなければ瞬間変更
			if (!time){
			
				model.waitingClock.start()
				vrm.humanoid.setNormalizedPose(poseJson)
				
				//待機モーションの再設定
				this.saveWaitingAnimationVal(vrm.humanoid, model)

				if (cb && typeof cb === 'function') cb()
				return
			}

			//アニメーション中は待機モーションを強制的に止める
			model.isAnimating = true;


			// 初期値と目標値をセットアップ
			const tmpPose = vrm.humanoid.getNormalizedPose();

			for (const key in poseJson) {
				//数値の異なるrotationのみ処理する
				if (tmpPose[key] && array_equal(tmpPose[key].rotation, poseJson[key].rotation) == false ) {
					initialValues[key] = tmpPose[key].rotation;
					targetValues[key] = poseJson[key].rotation;
				}
			}

			//配列の比較用
			function array_equal(arr1, arr2) {
				return arr1.length === arr2.length && arr1.every((value, index) => value === arr2[index]);
			}

			//変更する箇所の領域確保
			const currentValue = {};
			for (const key in targetValues) {
				currentValue[key] = { rotation: new Array(initialValues[key].length) };
			}

			const easingFunc = this.easing[func] || this.easing.default;
			const startTime = performance.now();

			const tick = (timestamp) => {
				const elapsedTime = timestamp - startTime;

				let progress
				if (time !== 0) {
					progress = Math.max(0, Math.min(elapsedTime / time, 1))
				} else {
					progress = 1
				}

				//スキップが有効の場合は割り込み処理
				if (skip && tStat.is_skip) progress = 1
				

				if (progress < 1) {
				
					const val = easingFunc(progress);

					// イージングの計算を適用
					for (const key in targetValues) {
						for (let i = 0; i < initialValues[key].length; i++) {
							currentValue[key].rotation[i] = initialValues[key][i] + (targetValues[key][i] - initialValues[key][i]) * val;
						}
					}

					vrm.humanoid.setNormalizedPose(currentValue)
				
					model.poseRequestId = requestAnimationFrame(tick);
				} else {
					//完了時
					vrm.humanoid.setNormalizedPose(targetValues);

					//待機モーションの再設定
					model.waitingClock.start()
					that.saveWaitingAnimationVal(vrm.humanoid, model)
					model.isAnimating = false;

					if (cb && typeof cb === 'function' && wait) cb()
				}
			};
			tick(startTime);

			//waitがfalseの時は即NextOrder
			if (cb && typeof cb === 'function' && !wait) cb()

		},

		//目線変更
		// VRoid.three.lookAt("model1", 0.5, 0, 0)
		lookAt: function (modelID, x, y, z, time, func, base, cb, wait, skip) {
			//waitのデフォルト値をセット
			if (wait === undefined) wait = true;
			time = Number(time)

			const model = this.model[modelID]
			const vrm = this.model[modelID].vrm;

			const tStat = TYRANO.kag.stat
			const statVRoid = tStat.VRoid;
			const saveModel = statVRoid.model[modelID];
			
			//セーブデータのカメラ目線を解除
			saveModel.lookingCamera = false

			//現在のポジションをターゲットから取得
			let startPosition
			if (vrm.lookAt.target) {
				startPosition = new THREE.Vector3(vrm.lookAt.target.position.x, vrm.lookAt.target.position.y, vrm.lookAt.target.position.z)
			}

			//セーブデータの作成
			//カメラ目線に戻すときにsaveModel.lookAtTargetは削除される
			if (!saveModel.lookAtTarget) saveModel.lookAtTarget = {}

			let saveData
			//camera or model
			if (base == "model" && startPosition) {
				//現在のtargetを基準にする。ない場合はカメラ指定に回す
				saveData = startPosition.clone();
			} else {
				//カメラを基準にする
				saveData = this.layer[model.layerID].camera.position.clone();
			}
			saveData.add(new THREE.Vector3(x, y, z))

			saveModel.lookAtTarget.x = saveData.x
			saveModel.lookAtTarget.y = saveData.y
			saveModel.lookAtTarget.z = saveData.z
			
			const endPosition = new THREE.Vector3(saveModel.lookAtTarget.x, saveModel.lookAtTarget.y, saveModel.lookAtTarget.z)

			// 注視するオブジェクトの初期化
			model.lookAtTarget = new THREE.Object3D()

			//前回の変更が残っていたら止める
			cancelAnimationFrame(model.requestlookAtId)

			//時間指定、もしくは前回のtargetがなければ瞬間変更
			if (!time || !startPosition){
				model.lookAtTarget.position.copy(endPosition);
				vrm.lookAt.target = model.lookAtTarget

				if (cb && typeof cb === 'function') cb()
				return
			}

			const easingFunc = this.easing[func] || this.easing.default;
			const startTime = performance.now();

			const tick = (timestamp) => {
				const elapsedTime = timestamp - startTime;

				let progress
				if (time !== 0) {
					progress = Math.max(0, Math.min(elapsedTime / time, 1))
				} else {
					progress = 1
				}

				//スキップが有効の場合は割り込み処理
				if (skip && tStat.is_skip) progress = 1

				if (progress < 1) {
					const val = easingFunc(progress);

					model.lookAtTarget.position.copy(new THREE.Vector3(startPosition.x + (endPosition.x - startPosition.x) * val, startPosition.y + (endPosition.y - startPosition.y) * val, startPosition.z + (endPosition.z - startPosition.z) * val));
					model.requestlookAtId = requestAnimationFrame(tick);
				} else {
					model.lookAtTarget.position.copy(endPosition);
					if (cb && typeof cb === 'function' && wait) cb()
				}
			};
			model.lookAtTarget.position.copy(startPosition)
			vrm.lookAt.target = model.lookAtTarget
			tick(startTime);


			//waitがfalseの時は即NextOrder
			if (cb && typeof cb === 'function' && !wait) cb()

		},

		//データロード時に使用
		loadLookAt: function (modelID) {
			const model = this.model[modelID]
			const vrm = this.model[modelID].vrm;
			const statVRoid = TYRANO.kag.stat.VRoid;
			const saveModel = statVRoid.model[modelID];
			
			const lookAtTarget = saveModel.lookAtTarget
			
			model.lookAtTarget = new THREE.Object3D()
			model.lookAtTarget.position.copy(new THREE.Vector3(lookAtTarget.x, lookAtTarget.y, lookAtTarget.z));
			vrm.lookAt.target = model.lookAtTarget
		
		},

		//カメラ目線に戻すときに使用
		// VRoid.three.lookAtCamera("model1", 1000)
		lookAtCamera: function (modelID, time, func, cb, wait, skip) {
			//waitのデフォルト値をセット
			if (wait === undefined) wait = true;
			time = Number(time)

			const model = this.model[modelID]
			const vrm = this.model[modelID].vrm;

			const tStat = TYRANO.kag.stat
			const statVRoid = tStat.VRoid;
			const saveModel = statVRoid.model[modelID];
			
			//セーブデータのカメラ目線を有効化
			saveModel.lookingCamera = true
			
			//現在のポジションをターゲットから取得
			let startPosition
			if (vrm.lookAt.target) {
				startPosition = new THREE.Vector3(vrm.lookAt.target.position.x, vrm.lookAt.target.position.y, vrm.lookAt.target.position.z)
			}

			//セーブデータの作成
			//saveModel.lookAtTargetを削除する
			delete saveModel.lookAtTarget

			// 注視するオブジェクト 再びnewする必要あり
			model.lookAtTarget = new THREE.Object3D()

			//前回の変更が残っていたら止める
			cancelAnimationFrame(model.requestlookAtId)

			const camera = this.layer[model.layerID].camera
			//時間指定、もしくは前回のtargetがなければ瞬間変更
			if (!time || !startPosition){
				vrm.lookAt.target = camera

				if (cb && typeof cb === 'function') cb()
				return
			}

			const easingFunc = this.easing[func] || this.easing.default;
			const startTime = performance.now();

			const tick = (timestamp) => {
				const elapsedTime = timestamp - startTime;

				let progress
				if (time !== 0) {
					progress = Math.max(0, Math.min(elapsedTime / time, 1))
				} else {
					progress = 1
				}

				//スキップが有効の場合は割り込み処理
				if (skip && tStat.is_skip) progress = 1

				if (progress < 1) {
					const val = easingFunc(progress);

					model.lookAtTarget.position.copy(new THREE.Vector3(startPosition.x + (camera.position.x - startPosition.x) * val, startPosition.y + (camera.position.y - startPosition.y) * val, startPosition.z + (camera.position.z - startPosition.z) * val));
					model.requestlookAtId = requestAnimationFrame(tick);
				} else {
					vrm.lookAt.target = camera
					if (cb && typeof cb === 'function' && wait) cb()
				}
			};
			model.lookAtTarget.position.copy(startPosition)
			vrm.lookAt.target = model.lookAtTarget
			tick(startTime);

			//waitがfalseの時は即NextOrder
			if (cb && typeof cb === 'function' && !wait) cb()

		},

		//アニメーションファイルのimport。
		// VRoid.three.importAnimation("VRMA_01.vrma, VRMA_02.vrma")
		importAnimation: function (storage, wait, cb) {
			//インポートの保存
			const statVRoid = TYRANO.kag.stat.VRoid;
			if (!statVRoid.anim) statVRoid.anim = []

			//新しい要素を追加する前に、すでに存在するかどうかをチェック
			if (!statVRoid.anim.some(exisElem => exisElem === storage)) {
				statVRoid.anim.push(storage);
			}

			const storageArr = storage.split(',');
			const promises = [];
			const _warn = console.warn;

			storageArr.forEach(function(file) {
				file = file.trim();

				// 先頭が./なら削除
				if (file.startsWith("./")) {
					file = file.substring(2);
				}
				
				// 拡張子を取り出す
				const type = file.substring(file.lastIndexOf(".") + 1);
				
				// 拡張子を削除してnameにする
				let name;
				const dotIndex = file.lastIndexOf(".");

				// .以降を削除
				if (dotIndex >= 0) {
					name = file.substring(0, dotIndex);
				} else {
					name = file;
				}

				if (VRoid.three[type] && !VRoid.three[type][name]) {
					//一時的に警告を無効化
					console.warn = function() {};

					const promise = new Promise(function(resolve, reject) {
					
						if (type == "vrma") {
							const moduleURL = "./module/three-vrm/three-vrm-animation.module.min.js"
							TYRANO.kag.stat.VRoid.module[moduleURL] = true

							VRoid.three.importModule("VRMAnimationLoaderPlugin", moduleURL).then( ( VRMAnimationLoaderPlugin ) => {

								const loader = new GLTFLoader();
								loader.crossOrigin = 'anonymous';
								loader.register((parser) => {
									return new VRMAnimationLoaderPlugin(parser);
								});


								loader.load(

									"./data/others/plugin/vrm/_animation/" + file,

									// called when the resource is loaded
									(gltf) => {
										const vrmAnimations = gltf.userData.vrmAnimations
										if (vrmAnimations != null) {
											VRoid.three.vrma[name] = vrmAnimations
										}
										resolve();
									},
									// called while loading is progressing
									(progress) => {
										//console.log('Loading model...', 100.0 * (progress.loaded / progress.total), '%')
									},

									// called when loading has errors
									(error) => {
										console.log(error)
										VRoid.three.error("VRMAデータのロード時にエラーが発生しました。")
										resolve();
									}
								)

							});

						} else if (type == "fbx") {
							const moduleURL = "./module/mixamo/loadMixamoAnimation.js"
							TYRANO.kag.stat.VRoid.module[moduleURL] = true

							VRoid.three.importModule("loadMixamoAsset", moduleURL).then( ( loadMixamoAsset ) => {

								loadMixamoAsset( "./data/others/plugin/vrm/_animation/" + file ).then( ( asset ) => {
									if (asset != null) {
										VRoid.three.fbx[name] = asset
									}
									resolve();
								}).catch((error) => {
									console.log(error)
									VRoid.three.error("FBXデータのロード時にエラーが発生しました。")
									resolve();
								});
							}).catch((error) => {
								console.log(error)
								VRoid.three.error("FBXデータのロード時にエラーが発生しました。")
								resolve();
							});
						}
					
					});
					
					promises.push(promise);
				}

			});

			// 全ての処理が終了後にnextorder
			Promise.all(promises).then(function() {
				//警告を戻す
				console.warn = _warn;
				if (cb && typeof cb === 'function' && wait) setTimeout(cb, 0)
			});
			
			if (cb && typeof cb === 'function' && !wait) cb()
		},

		//登録したVRMAやFBXファイルの再生
		//VRoid.three.animation("model1", "VRMA_01")
		animation: async function (modelID, animID, rate, loop, fadeIn, fadeOut, wait, skip, cb, type, keep, duration, endTime, emoTimeline) {
			const model = this.model[modelID]
			const vrm = this.model[modelID].vrm;
			const statVRoid = TYRANO.kag.stat.VRoid;
			const saveModel = statVRoid.model[modelID];

			//ループが0(無限)の時のみセーブデータから再現するため保存
			if (loop === 0) {
				let expression
				if (saveModel.expression) expression = $.extend(true, [], saveModel.expression)
				saveModel.mixer = {
					rate: rate,
					storage: animID,
					fadeIn: fadeIn,
					fadeOut: fadeOut,
					type: type,
					duration: duration,
					endTime: endTime,
					emoTimeline: emoTimeline,
					expression: expression,
				}
				
				//無限ループの場合はwaitを強制的にfalse
				wait = false;
			} else {
				delete saveModel.mixer
			}

			//実行中の場合はキャンセル
			if ( model.mixer ) {
				$(model.mixer).off();
				model.mixer.stopAllAction();
			}
			
			model.mixer = new THREE.AnimationMixer(vrm.scene);
			
			//一時的に警告を無効化
			const _warn = console.warn;
			console.warn = function() {};
			let clip
			if (type == "fbx") {
				const loadMixamoClip = await this.importModule("loadMixamoClip", "./module/mixamo/loadMixamoAnimation.js")
				clip = loadMixamoClip(this.fbx[animID], vrm ) 
			} else {
				const createVRMAnimationClip = await this.importModule("createVRMAnimationClip", "./module/three-vrm/three-vrm-animation.module.min.js")
				clip = createVRMAnimationClip(this.vrma[animID][0], vrm);
			}
			console.warn = _warn;

			//ループではなく、keepが指定されていた場合は最終フレームを記憶しておく
			if (loop !== 0 && keep) {
				//endTimeの方が小さければendTimeを優先
				let tmpDuration = clip.duration
				if (endTime > 0 && endTime < clip.duration) {
					tmpDuration = endTime
				}
				saveModel.mixer = {
					storage: animID,
					keep: true,
					duration: tmpDuration,
					endTime: endTime,
					type: type,
				}
			}

			//msをsに変換
			fadeIn *= 0.001
			fadeOut *= 0.001

			//スキップ時は速度を上げる
			if (TYRANO.kag.stat.is_skip && skip) {
				fadeIn *= 0.1
				fadeOut *= 0.1
				rate *= 10
			}

			model.mixer.timeScale = rate

			model.mixer.action = model.mixer.clipAction( clip )
			model.mixer.action.setLoop(THREE.LoopOnce);
			
			//開始時間を記録
			model.mixer.action.startTime = duration

			//終了時間を追加
			if (endTime) model.mixer.action.endTime = endTime
			
			//emoTimelineを設定
			setTimeline()
			
			//最後の体勢を維持
			model.mixer.action.clampWhenFinished = true;
			model.mixer.action.play();

			//何秒から再生するか
			if (duration) model.mixer.setTime(duration)
			model.mixer.action.fadeIn(fadeIn)

			let loopCount = 0
			$(model.mixer).on('finished', function(e) {
				loopCount++;
				if (loop === 0 || loopCount < loop) {
					//0の時は無限ループ もしくはloopCountがloop値よりも小さい場合
					model.mixer.action.reset()
					if (duration > 0) model.mixer.setTime(duration)

					//emoTimelineを最設定
					setTimeline()
					
				} else {

					//ループカウント終了時 keepがtrueならfadeOutが設定されていても元の状態に戻さない
					model.mixer.action.paused = true
					if (!keep) {
						//ポーズの復元すると一瞬動きがおかしくなる
						//VRoid.three.pose(modelID, saveModel.pose)
						model.mixer.action.fadeOut(fadeOut);
					}
					$(model.mixer).off();
					
					setTimeout(() => {
						if (cb && typeof cb === 'function' && wait) cb()
					}, (fadeOut * 1000));
				}
			});

			//開始と終了が同じときはその状態で終了
			if (endTime > 0 && duration === endTime) model.mixer.dispatchEvent({ type: 'finished', action: model.mixer.action });

			//waitがfalseの時は読み込んだ後にNextOrder
			if (cb && typeof cb === 'function' && !wait) cb()
			
			function setTimeline () {
				if (emoTimeline) {
					if (VRoid.three.animEmo[emoTimeline]) {
						model.mixer.action.emoTimeline = $.extend(true,{}, VRoid.three.animEmo[emoTimeline]);
					}
				}
			}
		},

		//VRoid.three.stop_animation("model1", 2000)
		stop_animation: function (modelID, fadeOut, wait, skip, cb) {

			const model = this.model[modelID]
			const statVRoid = TYRANO.kag.stat.VRoid;
			const saveModel = statVRoid.model[modelID];

			//msをsに変換
			fadeOut *= 0.001

			//スキップ時でwait指定がある場合は速度を上げる
			if (TYRANO.kag.stat.is_skip && skip && wait) {
				fadeOut *= 0.1
			}
			
			//ポーズを復元
			this.pose(modelID, saveModel.pose)

			delete saveModel.mixer
			$(model.mixer).off();
			if (model.mixer && model.mixer.action) model.mixer.action.fadeOut(fadeOut);
			
			setTimeout(() => {
				if (cb && typeof cb === 'function' && wait) cb()
			}, (fadeOut * 1000));

			//waitがfalseの時は即NextOrder
			if (cb && typeof cb === 'function' && !wait) cb()

		},

		//モデルの表情変更
		// VRoid.three.emotion("model1", "joy", 1000)
		emotion: function (modelID, eName, time, func, cb, wait, skip, diff, emoID, emoval) {
			//waitのデフォルト値をセット
			if (wait === undefined) wait = true;

			const model = this.model[modelID]
			const vrm = this.model[modelID].vrm;

			let initialValues = {};
			let targetValues = {};
			let requestId;
			let emotionObj;
			
			//nameとIDどちらも指定していた場合はemoID優先
			if (eName && emoID) {
				eName = ""
			}

			if (eName && this.emotionObj[eName]) {
				emotionObj = this.emotionObj[eName]
			} else if (eName) {
				this.error(eName + " に設定された表情データがありません。")
				if (cb && typeof cb === 'function') cb()
				return;
			} else {
				//emoIDが指定されているパターン。emoIDとemovalをもとにemotionObjの作成
				emotionObj = [{"expressionName": emoID, "val": Number(emoval)}]
			}

			model.isEmotion = true

			const tStat = TYRANO.kag.stat
			const statVRoid = tStat.VRoid;
			const saveModel = statVRoid.model[modelID];

			// 初期値と目標値をセットアップ
			// セーブ用のデータも保存
			if (!diff) {
				//差分が無効の場合はtarget全てに0を入れる
				vrm.expressionManager.expressions.forEach(function (data) {
					targetValues[data.expressionName] = 0;
				});
				//前回の変更が残っていたら止める
				cancelAnimationFrame(model.requestEmoId)
			}


			//現在値の設定
			vrm.expressionManager.expressions.forEach(function (data) {
				initialValues[data.expressionName] = vrm.expressionManager.getValue(data.expressionName);
			});

			//目標値の設定
			emotionObj.forEach(function (data) {
				targetValues[data.expressionName] = data.val;
			});

			//データの保存
			if (!saveModel.expression) {
				//設定がない時は初期化
				let i = 0;
				saveModel.expression = []

				vrm.expressionManager.expressions.forEach(function (data) {
					if (data.expressionName) {
						//saveModel.expression[i] = {expressionName: data.expressionName, val: vrm.expressionManager.getValue(data.expressionName)}
						saveModel.expression[i] = {expressionName: data.expressionName, val: 0}
					}
					i++
				});
				//delete i
				i = undefined;
			}
			//セーブ用データに各ブレンドシェイプを格納
			saveModel.expression.forEach(function (data) {
				let expressionName = data.expressionName;
				let currentValue = targetValues[expressionName];
				if (currentValue !== undefined) {
					data.val = currentValue;
				}
			});

			//時間指定がなければ瞬間変更
			if (!time){
				// 各ブレンドシェイプを適用
				for (const expressionName in targetValues) {
					vrm.expressionManager.setValue(expressionName, targetValues[expressionName]);
				}
				
				cancelAnimationFrame(model.requestEmoId)
				vrm.expressionManager.update();

				model.isEmotion = false
				if (cb && typeof cb === 'function') cb()
				return;
			}

			//同一値を削除
			for (const expressionName in targetValues) {
				const initialValue = initialValues[expressionName];
				const targetValue = targetValues[expressionName];

				if (initialValue == targetValue) {
					delete initialValues[expressionName]
					delete targetValues[expressionName]
				}
			}

			const easingFunc = this.easing[func] || this.easing.default;
			const startTime = performance.now();

			const tick = (timestamp) => {
				const elapsedTime = timestamp - startTime;

				let progress
				if (time !== 0) {
					progress = Math.max(0, Math.min(elapsedTime / time, 1))
				} else {
					progress = 1
				}

				//スキップが有効の場合は割り込み処理
				if (skip && tStat.is_skip) progress = 1
				
				const val = easingFunc(progress);

				// 各ブレンドシェイプに対してアニメーションを適用
				for (const expressionName in targetValues) {
					const initialValue = initialValues[expressionName];
					const targetValue = targetValues[expressionName];

					const currentValue = initialValue + (targetValue - initialValue) * val;
					vrm.expressionManager.setValue(expressionName, currentValue);
				}

				if (progress < 1) {
					model.requestEmoId = requestAnimationFrame(tick);
				} else {
					model.isEmotion = false
					if (cb && typeof cb === 'function' && wait) cb()
				}
			};
			model.isEmotion = true
			tick(startTime);

			//waitがfalseの時は即NextOrder
			if (cb && typeof cb === 'function' && !wait) cb()

		},

		//VRoid.three.capture("VRoid", 3)
		capture: function (layerID, rate, timeOut, cb) {
			const thisLayer = this.layer[layerID];
			const tmpPR = thisLayer.renderer.getPixelRatio();
			
			if (timeOut === undefined) timeOut = 100

			if (rate === undefined) rate = 1

			//高画質化
			thisLayer.renderer.setPixelRatio(Number(rate));
			thisLayer.composer.setPixelRatio(Number(rate));

			//PixelRatio変更を少し待ってから処理
			setTimeout(() => {
				//preserveDrawingBufferを切っていても直前で更新すればとれる
				this.forceRenderUpdate(layerID)
				requestAnimationFrame(() => {
					const canvas = document.getElementById(layerID);

					canvas.toBlob(function(blob) {
						//PixelRatioを戻す
						thisLayer.renderer.setPixelRatio(tmpPR);
						thisLayer.composer.setPixelRatio(tmpPR);
					
						if (cb && typeof cb === 'function') {
							//cbがあればblobを返す
							cb(blob)
						} else {
							const ymd = new Date().toLocaleDateString('sv-SE');
							const time = new Date().toLocaleTimeString('ja-JP', {hour12:false});
							const fileName = layerID + "_"+ ymd + "_" + time;

							const link = document.createElement('a');
							link.download = fileName + ".png";
							link.href = URL.createObjectURL(blob);
							link.click();

						}

						//テストカメラ時のIDがあったらCSSを戻す
						$("#VRoid_test_camera_capture").css("pointer-events", "")

					}, "image/png");

				});
			}, Number(timeOut));

		},

		
		//生ポーズデータ入力して圧縮
		//VRoid.three.inputJson()
		inputJson: function () {
			$.getJSON("./data/others/plugin/vrm/_pose/input.json").done(function(json) {

				const strJson = JSON.stringify(json, null)

				//console.log(JSON.stringify(json, null, 2));
				console.log(strJson);
				
				const strComp = LZString.compressToBase64(strJson)

				console.log('json = "' + strComp + '"');
				
				const strDeco = LZString.decompressFromBase64(strComp);
				
				console.log(strJson == strDeco);

				const obj = JSON.parse(strDeco);
				console.log(obj);

			}).fail(function(err) { 
				VRoid.three.error(storage + " ファイルが存在しないか、jsonファイルの記述が間違っています。 ");
			});
		},

		//VRoid.three.poseJsonを圧縮して出力（VRoid_import_poseで取り込み時）
		//VRoid.three.convertJson()
		convertJson: function () {

			const strJson = JSON.stringify(VRoid.three.poseJson, null)

			//console.log(JSON.stringify(json, null));
			console.log(strJson);
			
			const strComp = LZString.compressToBase64(strJson)

			console.log('json = "' + strComp + '"');
			
			const strDeco = LZString.decompressFromBase64(strComp);
			
			console.log(strJson == strDeco);

			const obj = JSON.parse(strDeco);
			console.log(obj);

		},

		//圧縮された文字列を展開してjsonオブジェクトを返す
		decodeJson: function (str) {
			const strDeco = LZString.decompressFromBase64(str)
			return JSON.parse(strDeco);
		},
		
		/*
		//{"rotation":[0,0,0,1]}を補完
		//このコードで初期値の項目を削除できる
		json.replace(
		  /,\s*"\w+":\{"rotation":\[\s*0\s*,\s*0\s*,\s*0\s*,\s*1\s*\]\}|\s*"\w+":\{"rotation":\[\s*0\s*,\s*0\s*,\s*0\s*,\s*1\s*\]\},?/g,
		  ''
		);
		*/
		fixPose: function (poseJson) {
			for (const name in poseJson) {
				Object.keys(VRMHumanBoneList).forEach((key) => {
					const parts = VRMHumanBoneList[key]
					if (!poseJson[name][parts]) {
						poseJson[name][parts] = {rotation: [0, 0, 0, 1]}
					}
				});
			}
			return poseJson
		},

		//VRoid.three.testCamera("VRoid", "model1") //modelIDは省略可
		//VRoid.three.layer.VRoid.camera.position
		testCamera: async function (layerID, modelID, cb, isAdvanced) {
			//is_stopをtrue ゲームを停止状態にする
			const tmp_is_stop = TYRANO.kag.stat.is_stop;
			TYRANO.kag.stat.is_stop = true
		
			//キーコンフィグを保存して無効にする
			const tmpKeyconfig = TYRANO.kag.stat.enable_keyconfig;
			TYRANO.kag.stat.enable_keyconfig = false;
		
			const thisLayer = this.layer[layerID];

			// カメラが現在向いている方向を取得
			const direction = new THREE.Vector3();
			thisLayer.camera.getWorldDirection(direction);
			if (!isAdvanced) direction.z -= 1
			const targetPosition = thisLayer.camera.position.clone().add(direction);

			const OrbitControls = await this.importModule("OrbitControls", "./module/three/controls/OrbitControls.js")
			thisLayer.controls = new OrbitControls(thisLayer.camera, thisLayer.renderer.domElement)

			// 取得した方向を targetに設定
			thisLayer.controls.target.copy(targetPosition);
			thisLayer.controls.update();

			//以下を設定すると動きはなめらかになるけどlogの出力が増えて邪魔
			//thisLayer.controls.screenSpacePanning = true
			//thisLayer.controls.enableDamping = true;
			
			const $layerID = $("#" + layerID)
			
			//移動前の位置を保存
			const tmpParent = $layerID.parent();
			const tmpIndex = $layerID.css("z-index");
			
			$("#tyrano_base").append("<div id='VRoid_test_camera' style='position: absolute; z-index: 900000001;width: 100%;'></div>")
			$layerID.css({"z-index": "1", "pointer-events": "auto"}).appendTo('#VRoid_test_camera');
			thisLayer.controls.update()

			$("#VRoid_test_camera").on('touchmove wheel', (e) => {
				e.stopPropagation();
			});
		
			const pos = thisLayer.camera.position
			const rot = thisLayer.camera.rotation

			function outputLog(pos, rot) {
				console.log("pos.x = " + minRound(pos.x) + "\n" +
							"pos.y = " + minRound(pos.y) + "\n" +
							"pos.z = " + minRound(pos.z) + "\n" +
							"rot.x = " + minRound(rot.x) + "\n" +
							"rot.y = " + minRound(rot.y) + "\n" +
							"rot.z = " + minRound(rot.z))
				console.log("========")
				
				console.log("[VRoid_move_camera layerID=" + layerID + " x=" + minRound(pos.x) + " y=" + minRound(pos.y) + " z=" + minRound(pos.z) + " rotX=" + minRound(rot.x) + " rotY=" + minRound(rot.y) + " rotZ=" + minRound(rot.z) + "]")
				console.log("========")
			}
			outputLog(pos, rot)

			thisLayer.controls.addEventListener("change", () => {
				outputLog(pos, rot)
			});


			const scHeight = Number(TYRANO.kag.config.scHeight)

			let html = "<div id='VRoid_test_camera_close' style=' position: absolute; z-index: 2; background-color: rgba(0,0,0,0.5); color:#fff; width: 105px; font-size: 20px; height: 50px; line-height: 50px;right: 0; text-align: center;cursor: pointer;'>CLOSE</div>" +
				"<div id='VRoid_test_camera_capture' style='position: absolute; z-index: 2; background-color: rgba(255,255,255,0.5); color:#000; width: 105px; font-size: 14px; height: 50px; line-height: 50px;right: 0; top: " + (scHeight - 50)  + "px; text-align: center;cursor: pointer;'>CAPTURE</div>" +
				"<div id='VRoid_test_camera_range' style='position: absolute; z-index: 2; right: 125px; top: " + (scHeight - 42)  + "px;'><input id='capture_range' type='range' value='1' min='0.5' max='5' step='0.5' style='cursor: pointer; margin-left: 40px;'><textarea readonly id='capture_text' rows='1' style='resize: none;width: 30px;padding: 5px 10px; font-size: 14px; margin-left: 20px; background:rgba(255,255,255,0.8); border: 2px solid rgba(255,255,255,0.5); border-radius: 6px; overflow: hidden;'>x1.0</textarea></div>"

			//modelIDの指定があった場合のみ、ポーズ変更や編集を追加
			const modelPosition = {}; //モデルの初期値を格納する
			if (modelID) {
				modelPosition.x = TYRANO.kag.stat.VRoid.model[modelID].x
				modelPosition.y = TYRANO.kag.stat.VRoid.model[modelID].y
				modelPosition.z = TYRANO.kag.stat.VRoid.model[modelID].z
				html += "<select id='select_pose' style='background-color: rgba(255,255,255,0.8); position: absolute; z-index: 2; right: 120px; width: 144px; height: 39px; text-align: center; font-size: 18px; padding-left: 10px;'>"
					for (const key in VRoid.three.poseJson) {
						html += "<option value='" + key + "' id='" + key + "'>" + key + "</option>"
					}
				html += "</select>" +
				"<div style=' position: absolute; z-index: 2; background-color: rgba(0,0,0,0.5); color:#fff; width: 105px; font-size: 14px; height: 50px; line-height: 50px;right: 0; text-align: center; top:60px;'><label for='VRoid_test_camera_lookAt' style='cursor: pointer;'><input type='checkbox' id='VRoid_test_camera_lookAt' name='lookAt'  style='position: relative;top: 2px;'> カメラ目線</label></div>" +
				"<div style=' position: absolute; z-index: 2; background-color: rgba(0,0,0,0.5); color:#fff; width: 105px; font-size: 14px; height: 50px; line-height: 50px;right: 0; text-align: center; top:120px;'><label for='VRoid_test_camera_custom' style='cursor: pointer;'><input type='checkbox' id='VRoid_test_camera_custom' name='lookAt'  style='position: relative;top: 2px;'> ポーズ編集</label></div>" +
				"<div id='yure_range_div' style=' position: absolute; z-index: 2; background-color: rgba(0,0,0,0.5); color:#fff; width: 105px; font-size: 14px; height: 300px; line-height: 20px;right: 0; text-align: center; top:180px; padding-top: 14px;'>" +
					"モデルを揺らす<br><br>" +
					"X<br>" +
					"<input id='yure_range_x' class='yure_range' type='range' value='0' min='0' max='1' step='0.01' style='cursor: pointer; width: 80%;'><br>" +
					"Y<br>" +
					"<input id='yure_range_y' class='yure_range' type='range' value='0' min='0' max='1' step='0.01' style='cursor: pointer; width: 80%;'><br>" +
					"Z<br>" +
					"<input id='yure_range_z' class='yure_range' type='range' value='0' min='0' max='1' step='0.01' style='cursor: pointer; width: 80%;'><br>" +
					"Speed<br>" +
					"<input id='yure_range_t' class='yure_range' type='range' value='1' min='0.2' max='3' step='0.01' style='cursor: pointer; width: 80%;'><br>" +
					"<br><button id='yure_reset' type='button' style='cursor: pointer;'>リセット</button>" +
				"</div>"
			}

			$("#VRoid_test_camera").append(html)

			let tickID
			const clock = new THREE.Clock();
			function tick() {
				thisLayer.controls.update()
				tickID = requestAnimationFrame(tick)
				if (modelID) yureTest()
			}
			tick()
			
			
			$("#yure_reset").on("click", (e) => {
				document.getElementById('yure_range_x').value = 0;
				document.getElementById('yure_range_y').value = 0;
				document.getElementById('yure_range_z').value = 0;
				document.getElementById('yure_range_t').value = 1;
				VRoid.three.model[modelID].vrm.scene.position.set(modelPosition.x, modelPosition.y, modelPosition.z)
			})

			$("#VRoid_test_camera_close").on("click", (e) => {
				// 元の位置に戻す
				cancelAnimationFrame(tickID)
				thisLayer.controls.dispose();
				$layerID.css({"z-index": tmpIndex, "pointer-events": "none"}).appendTo(tmpParent);
				$("#yure_reset").click()

				//ポーズ編集が有効の時は削除する
				if (document.getElementById('VRoid_test_camera_custom') && document.getElementById('VRoid_test_camera_custom').checked) $("#VRoid_test_camera_custom").click()
				$("#VRoid_test_camera").remove();

				//ゲーム変数に保存するために実行
				this.move({type: "layer", layerID: layerID, x: pos.x, y:pos.y, z:pos.z, rotX:rot.x, rotY:rot.y, rotZ:rot.z})

				//キーコンフィグを戻す
				TYRANO.kag.stat.enable_keyconfig = tmpKeyconfig;

				//is_stopを戻す
				TYRANO.kag.stat.is_stop = tmp_is_stop;
				
				//カメラ目線を直す
				if (modelID) {
					if (tmpLookAt) {
						vrm.lookAt.target = thisLayer.camera;
					} else {
						delete vrm.lookAt.target
						vrm.lookAt.reset()
					}
				}

				
				$(document).off(".test_camera")
				
				//nextOrder
				if (cb && typeof cb === 'function') cb()

				e.stopPropagation();
			})

			$("#VRoid_test_camera_capture").on("click", (e) => {
				//スクリーンショット撮影
				$("#VRoid_test_camera_capture").css("pointer-events", "none")
				this.capture(layerID, $("#capture_range").val())
				e.stopPropagation();
			})

			$("#capture_range").on('change input', function() {
				$("#capture_text").html("x" + $(this).val());
			});
			
			$("#select_pose").change(function() {
				VRoid.three.pose(modelID, $(this).val())
			});

			//↑↓キーを押した時の処理
			$(document).on("keydown.test_camera",function(e){
				const select = $('#select_pose');
				if (select.length && (e.which == 38 || e.which == 40)) {
					e.preventDefault();
					const options = select.find('option');
					let selectedIndex = select.prop('selectedIndex');
					if (e.which == 38 && selectedIndex > 0) {
						selectedIndex--;
					} else if (e.which == 40 && selectedIndex < options.length - 1) {
						selectedIndex++;
					}
					select.prop('selectedIndex', selectedIndex);
					VRoid.three.pose(modelID, select.val())
				}
			});

			let vrm
			let tmpLookAt = false
			if (modelID) {
				//カメラ目線の初期設定
				vrm = this.model[modelID].vrm
				let camera_lookAt = document.getElementById('VRoid_test_camera_lookAt');
				if (vrm.lookAt.target) {
					camera_lookAt.checked = true;
					tmpLookAt = true;
				}

				$("#VRoid_test_camera_lookAt").on("click", (e) => {
					if (document.getElementById('VRoid_test_camera_lookAt').checked) {
						vrm.lookAt.target = thisLayer.camera;
					} else {
						delete vrm.lookAt.target
						vrm.lookAt.reset()
					}
					e.stopPropagation();
				});

				$("#VRoid_test_camera_custom").one("click", (e) => {
					e.stopPropagation();
					document.getElementById('VRoid_test_camera_custom').checked = true;
					this.useTransformControls(modelID)
				});

			}

			let VRoid_test_camera = document.getElementById('VRoid_test_camera');

			VRoid_test_camera.addEventListener('click', function(e){
				e.stopPropagation();
			});
/*
			//カメラの現在の lookAt 方向を取得する関数
			function getCameraLookAt(camera) {
				//カメラの forward ベクトルを取得する
				const forward = new THREE.Vector3(0, 0, -1);
				forward.applyQuaternion(camera.quaternion); // カメラの回転を考慮

				//カメラの位置に forward ベクトルを加算し、lookAt の方向を計算する
				const lookAtDirection = new THREE.Vector3().addVectors(camera.position, forward);
				return lookAtDirection;
			}
*/

			//小さい数を四捨五入
			function minRound(val) {
				const digit = 10000000
				return (Math.round(val * digit) / digit)
			}
			
			//揺れテスト
			function yureTest() {
				const elapsedTime = clock.getElapsedTime();
				const xAmplitude = parseFloat(document.getElementById('yure_range_x').value);
				const yAmplitude = parseFloat(document.getElementById('yure_range_y').value);
				const zAmplitude = parseFloat(document.getElementById('yure_range_z').value);
				const timeScale = parseFloat(document.getElementById('yure_range_t').value);

				// sin波で揺れを計算
				const newX = modelPosition.x + xAmplitude * Math.sin(elapsedTime * Math.PI * timeScale);
				const newY = modelPosition.y + yAmplitude * Math.sin(elapsedTime * Math.PI * timeScale);
				const newZ = modelPosition.z + zAmplitude * Math.sin(elapsedTime * Math.PI * timeScale);

				VRoid.three.model[modelID].vrm.scene.position.set(newX, newY, newZ)

			}

			//スライダー変更時にclockリセット
			document.querySelectorAll('.yure_range').forEach(slider => {
				slider.addEventListener('input', clock.start());
			});
		},
		
		//リップシンク
		lipSync: function (pm, modelID, lipSyncData, posOnly) {
			const model = VRoid.three.model[modelID]
			const vrm = model.vrm
			const vo = TYRANO.kag.tmp.map_se[pm.buf]
			const lipList = lipSyncData.invalidList
			
			const that = this
			const headPosition = new THREE.Vector3();
			const cameraPosition = new THREE.Vector3();
			const camera = that.layer[model.layerID].camera
			const head = vrm.humanoid.getNormalizedBoneNode('head');
			
			if (posOnly) {
				const pos = getModelPos()
				vo.pos(pos[0], pos[1], pos[2])
				return
			}

			const analyser = Howler.ctx.createAnalyser();
			analyser.fftSize = 256;
			
			vo._sounds[0]._node.connect(analyser);


			const tStat = TYRANO.kag.stat
			const saveModel = tStat.VRoid.model[modelID];
			const expression = saveModel.expression
			function tick() {
				if ( vrm ) {

					if (vo && vo.playing()) {
						requestAnimationFrame(tick)

						//モデルの位置で再生位置を変更する
						if (lipSyncData.isSyncPos) {
							const pos = getModelPos()
							vo.pos(pos[0], pos[1], pos[2])
						}

						//無効リストに入っている表情を0に
						for (let i = 1; i < lipList.length; i++) {
							vrm.expressionManager.setValue(lipList[i], 0)
						}

						//既存の表情をmicMix値で合成
						for (const lip in lipSyncData.lipData) {
							let minVal = 0;
							for (let key in expression) {
								if (lip == expression[key].expressionName) {
									minVal = expression[key].val * lipSyncData.micMix;
								}
							}
							vrm.expressionManager.setValue(lip, Math.max(getByteFrequencyDataAverage(analyser, lipSyncData.lipData[lip]), minVal))
						}

					} else {
						for (let key in expression) {
							for (let i = 0; i < lipList.length; i++) {
								if (lipList[i] == expression[key].expressionName) {
									VRoid.three.emotion(modelID, "", lipSyncData.fadeOut, "default", null, false, false, true, lipList[i], expression[key].val)
								}
							}
						}

					}

				}
			}
			tick()
			

			function getModelPos (){
				head.getWorldPosition(headPosition)
				camera.getWorldPosition(cameraPosition);
				// 各軸の距離を計算
				const distanceX = (headPosition.x - cameraPosition.x) * lipSyncData.posRate;
				const distanceY = (headPosition.y - cameraPosition.y) * lipSyncData.posRate;
				const distanceZ = (headPosition.z - cameraPosition.z);

				return [distanceX, distanceY, distanceZ]
			}

			//再生中の音量を正規化して取得
			function getByteFrequencyDataAverage(analyser, val) {
				const bufferLength = analyser.frequencyBinCount;
				const dataArray = new Uint8Array(bufferLength);

				analyser.getByteFrequencyData(dataArray);

				let sum = 0;
				for (let i = 0; i < bufferLength; i++) {
					sum += dataArray[i];
				}

				const average = sum / bufferLength;
				let normalizedValue = average / 255;  // 0から1の範囲に正規化
				
				normalizedValue = normalizedValue * val;  //1～0が入っているはず
				
				//最後にコンフィグvolumeで補正する　ボリューム0.2くらいまではいい感じ
				const voVolume = vo.volume()
				normalizedValue = normalizedValue * (1 + Math.pow(1 - voVolume, 2));
				normalizedValue = Math.min(normalizedValue  * lipSyncData.micVolume, 1);  //micVolumeの値で補正
				
				//閾値以下なら0にする
				if (normalizedValue <= lipSyncData.micMinLevel) normalizedValue = 0

				return normalizedValue
			}
		},

		//ポーズデータ編集用の追加関数
		//VRoid.three.useTransformControls("model1")
		useTransformControls: async function (modelID) {
			const model = this.model[modelID]
			const vrm = model.vrm
			const scene = vrm.scene
			const layerID = model.layerID
			const thisLayer = this.layer[layerID];
		
			//待機モーションを止める
			const tmpIsAnimating = model.isAnimating
			model.isAnimating = true
			this.updateWaitingAnimation(vrm.humanoid, model.waitingAnimationVal, 0)
			
			//揺れチェック機能をとめる
			$("#yure_reset").click()
			$("#yure_range_div").css("display", "none")
		
			//TransformControlsのインポート
			const TransformControls = await this.importModule("TransformControls", "./module/three/controls/TransformControls.js")

			const tcSize = 0.2
			const sensitivity = 1;  // 感度調整用のスケール（0.1～1.0などの範囲で調整）　未使用
			
			const historyData = [];
			let historyData2 = [];

			let transformControlsMap = {};
			const normalizedPose = vrm.humanoid.getNormalizedPose()
			Object.keys(normalizedPose).forEach((key) => {
				const transformControls = new TransformControls(thisLayer.camera, thisLayer.renderer.domElement);

				// OrbitControlsとTransformControlsのイベント設定
				transformControls.addEventListener('dragging-changed', function (event) {
					thisLayer.controls.enabled = !event.value;  // OrbitControlsの無効化/有効化
					
					if (event.value) {
						const pose = vrm.humanoid.getNormalizedPose()
						if (historyData.length > 0) {
							if (JSON.stringify(historyData[historyData.length - 1], null) !== JSON.stringify(pose, null)) {
								historyData.push(pose)

								$VRoid_test_camera_undo.css("opacity", "")
								historyData2 = []
								$VRoid_test_camera_redo.css("opacity", "0.5")

							}
						} else {
							historyData.push(pose)
							historyData2 = []
							$VRoid_test_camera_redo.css("opacity", "0.5")
						}
					} else {
						if (historyData.length > 0) $VRoid_test_camera_undo.css("opacity", "")
					}
					
					Object.values(transformControlsMap).forEach(tc => {
						tc.size = tcSize;
						tc.visible = false;
						tc.enabled = false;
					})
					transformControls.size = 1.5;
					transformControls.visible = true
					transformControls.enabled = true
					$VRoid_test_camera_bonename.text(transformControls.object.name.replace("Normalized_", ""))
					
					$VRoid_test_camera_betsu.css("opacity", "")
				});

				// ドラッグイベントで感度を調整
				transformControls.addEventListener('objectChange', function () {
					if (transformControls.dragging && transformControls.getMode() === 'rotate') {
						const rotation = transformControls.object.rotation;
						//感度調整未使用
						//rotation.x *= sensitivity;
						//rotation.y *= sensitivity;
						//rotation.z *= sensitivity;
						$VRoid_test_camera_bonex.text("x: " + rotation.x)
						$VRoid_test_camera_boney.text("y: " + rotation.y)
						$VRoid_test_camera_bonez.text("z: " + rotation.z)
					}
				});

				const boneNode = vrm.humanoid.getNormalizedBoneNode(key)
				thisLayer.scene.add(transformControls);
				transformControls.setMode('rotate');
				transformControls.attach(boneNode)
				transformControls.size = tcSize;

				transformControlsMap[boneNode.uuid] = transformControls;
			});

			let html = "<div class='VRoid_test_camera_custom_ui' id='VRoid_test_camera_import' style=' position: absolute; z-index: 2; background-color: rgba(0,0,0,0.5); color:#fff; width: 105px; font-size: 20px; height: 50px; line-height: 50px; left: 340px; text-align: center; top:0px;cursor: pointer;'>IMPORT</div>" +
				"<div class='VRoid_test_camera_custom_ui' id='VRoid_test_camera_export' style=' position: absolute; z-index: 2; background-color: rgba(0,0,0,0.5); color:#fff; width: 105px; font-size: 20px; height: 50px; line-height: 50px; left: 464px; text-align: center; top:0px;cursor: pointer;'>EXPORT</div>" +
				"<div class='VRoid_test_camera_custom_ui' id='VRoid_test_camera_undo' style=' position: absolute; z-index: 2; background-color: rgba(0,0,0,0.5); color:#fff; width: 105px; font-size: 20px; height: 50px; line-height: 50px; left: 588px; text-align: center; top:0px;cursor: pointer;'>UNDO</div>" +
				"<div class='VRoid_test_camera_custom_ui' id='VRoid_test_camera_redo' style=' position: absolute; z-index: 2; background-color: rgba(0,0,0,0.5); color:#fff; width: 105px; font-size: 20px; height: 50px; line-height: 50px; left: 712px; text-align: center; top:0px;cursor: pointer;'>REDO</div>" +
				"<div class='VRoid_test_camera_custom_ui' id='VRoid_test_camera_betsu' style=' position: absolute; z-index: 2; background-color: rgba(0,0,0,0.5); color:#fff; width: 105px; font-size: 20px; height: 50px; line-height: 50px; left: 836px; text-align: center; top:0px;cursor: pointer;'>選択解除</div>" +
				"<div class='VRoid_test_camera_custom_ui' id='VRoid_test_camera_bonename' style=' position: absolute; z-index: 2; background-color: rgba(0,0,0,0.5); color:#fff; width: 600px; font-size: 20px; height: 30px; line-height: 30px;left: 340px; text-align: center; top:690px'></div>" +
				"<div class='VRoid_test_camera_custom_ui' id='VRoid_test_camera_bonex' style=' position: absolute; z-index: 2; background-color: rgba(0,0,0,0.5); color:#fff; padding: 0 10px; width: 180px; font-size: 12px; height: 20px; line-height: 30px;left: 340px; text-align: left; top:670px; white-space: nowrap;'></div>" +
				"<div class='VRoid_test_camera_custom_ui' id='VRoid_test_camera_boney' style=' position: absolute; z-index: 2; background-color: rgba(0,0,0,0.5); color:#fff; padding: 0 10px; width: 180px; font-size: 12px; height: 20px; line-height: 30px;left: 540px; text-align: left; top:670px; white-space: nowrap;'></div>" +
				"<div class='VRoid_test_camera_custom_ui' id='VRoid_test_camera_bonez' style=' position: absolute; z-index: 2; background-color: rgba(0,0,0,0.5); color:#fff; padding: 0 10px; width: 180px; font-size: 12px; height: 20px; line-height: 30px;left: 740px; text-align: left; top:670px; white-space: nowrap;'></div>"

				+ "<div class='VRoid_test_camera_custom_ui' style='font-size: 12px; position: absolute; z-index: 2; background-color: rgba(0,0,0,0.5); color:#fff; width: 105px; height: 480px; line-height: 1em; right: 0; text-align: center; top:180px;'>"
					+ "<div style='position: absolute; z-index: 2; top: 10px; left: 10px; font-size: 14px;'>右手</div>"
					+ "<div style='position: absolute; z-index: 2; top: 10px; right: 10px;'><label for='yubi_r_ikkatu' style='cursor: pointer;'><input type='checkbox' id='yubi_r_ikkatu' name='right'  style='position: relative;top: 2px;'> 一括</label></div>"

					+ "<div style='position: absolute; z-index: 2; top: 30px; left: 10px;'>親指</div>"
					+ "<div style='position: absolute; z-index: 2; top: 70px; left: 10px;'>人差し指</div>"
					+ "<div style='position: absolute; z-index: 2; top: 110px; left: 10px;'>中指</div>"
					+ "<div style='position: absolute; z-index: 2; top: 150px; left: 10px;'>薬指</div>"
					+ "<div style='position: absolute; z-index: 2; top: 190px; left: 10px;'>小指</div>"

					+ "<div id='rightThumb_val'  style='position: absolute; z-index: 2; top: 32px; width: 45px; right: 10px; font-size: 10px; text-align: right;'>0.00</div>"
					+ "<div id='rightIndex_val'  style='position: absolute; z-index: 2; top: 72px; width: 45px; right: 10px; font-size: 10px; text-align: right;'>0.00</div>"
					+ "<div id='rightMiddle_val' style='position: absolute; z-index: 2; top: 112px; width: 45px; right: 10px; font-size: 10px; text-align: right;'>0.00</div>"
					+ "<div id='rightRing_val'   style='position: absolute; z-index: 2; top: 152px; width: 45px; right: 10px; font-size: 10px; text-align: right;'>0.00</div>"
					+ "<div id='rightLittle_val' style='position: absolute; z-index: 2; top: 192px; width: 45px; right: 10px; font-size: 10px; text-align: right;'>0.00</div>"

					+ "<input id='rightThumb'  class='yubi_range' type='range' value='0' min='0' max='1' step='0.01' style='display: block; cursor: pointer; width: 85px; left:10px; position: absolute; z-index: 2; top: 45px;'>"
					+ "<input id='rightIndex'  class='yubi_range' type='range' value='0' min='0' max='1' step='0.01' style='display: block; cursor: pointer; width: 85px; left:10px; position: absolute; z-index: 2; top: 85px;'>"
					+ "<input id='rightMiddle' class='yubi_range' type='range' value='0' min='0' max='1' step='0.01' style='display: block; cursor: pointer; width: 85px; left:10px; position: absolute; z-index: 2; top: 125px;'>"
					+ "<input id='rightRing'   class='yubi_range' type='range' value='0' min='0' max='1' step='0.01' style='display: block; cursor: pointer; width: 85px; left:10px; position: absolute; z-index: 2; top: 165px;'>"
					+ "<input id='rightLittle' class='yubi_range' type='range' value='0' min='0' max='1' step='0.01' style='display: block; cursor: pointer; width: 85px; left:10px; position: absolute; z-index: 2; top: 205px;'>"


					+ "<div style='position: absolute; z-index: 2; top: 250px; left: 10px; font-size: 14px;'>左手</div>"
					+ "<div style='position: absolute; z-index: 2; top: 250px; right: 10px;'><label for='yubi_l_ikkatu' style='cursor: pointer;'><input type='checkbox' id='yubi_l_ikkatu' name='left'  style='position: relative;top: 2px;'> 一括</label></div>"

					+ "<div style='position: absolute; z-index: 2; top: 270px; left: 10px;'>親指</div>"
					+ "<div style='position: absolute; z-index: 2; top: 310px; left: 10px;'>人差し指</div>"
					+ "<div style='position: absolute; z-index: 2; top: 350px; left: 10px;'>中指</div>"
					+ "<div style='position: absolute; z-index: 2; top: 390px; left: 10px;'>薬指</div>"
					+ "<div style='position: absolute; z-index: 2; top: 430px; left: 10px;'>小指</div>"

					+ "<div id='leftThumb_val'  style='position: absolute; z-index: 2; top: 272px; width: 45px; right: 10px; font-size: 10px; text-align: right;'>0.00</div>"
					+ "<div id='leftIndex_val'  style='position: absolute; z-index: 2; top: 312px; width: 45px; right: 10px; font-size: 10px; text-align: right;'>0.00</div>"
					+ "<div id='leftMiddle_val' style='position: absolute; z-index: 2; top: 352px; width: 45px; right: 10px; font-size: 10px; text-align: right;'>0.00</div>"
					+ "<div id='leftRing_val'   style='position: absolute; z-index: 2; top: 392px; width: 45px; right: 10px; font-size: 10px; text-align: right;'>0.00</div>"
					+ "<div id='leftLittle_val' style='position: absolute; z-index: 2; top: 432px; width: 45px; right: 10px; font-size: 10px; text-align: right;'>0.00</div>"

					+ "<input id='leftThumb'  class='yubi_range' type='range' value='0' min='0' max='1' step='0.01' style='display: block; cursor: pointer; width: 85px; left:10px; position: absolute; z-index: 2; top: 285px;'>"
					+ "<input id='leftIndex'  class='yubi_range' type='range' value='0' min='0' max='1' step='0.01' style='display: block; cursor: pointer; width: 85px; left:10px; position: absolute; z-index: 2; top: 325px;'>"
					+ "<input id='leftMiddle' class='yubi_range' type='range' value='0' min='0' max='1' step='0.01' style='display: block; cursor: pointer; width: 85px; left:10px; position: absolute; z-index: 2; top: 365px;'>"
					+ "<input id='leftRing'   class='yubi_range' type='range' value='0' min='0' max='1' step='0.01' style='display: block; cursor: pointer; width: 85px; left:10px; position: absolute; z-index: 2; top: 405px;'>"
					+ "<input id='leftLittle' class='yubi_range' type='range' value='0' min='0' max='1' step='0.01' style='display: block; cursor: pointer; width: 85px; left:10px; position: absolute; z-index: 2; top: 445px;'>"

				+ "</div>"

			$("#VRoid_test_camera").append(html)

			const $VRoid_test_camera_undo = $("#VRoid_test_camera_undo")
			const $VRoid_test_camera_redo = $("#VRoid_test_camera_redo")
			const $VRoid_test_camera_bonename = $("#VRoid_test_camera_bonename")
			const $VRoid_test_camera_betsu = $("#VRoid_test_camera_betsu")
			const $VRoid_test_camera_bonex = $("#VRoid_test_camera_bonex")
			const $VRoid_test_camera_boney = $("#VRoid_test_camera_boney")
			const $VRoid_test_camera_bonez = $("#VRoid_test_camera_bonez")

			$("#VRoid_test_camera_custom").one("click", (e) => {
				e.stopPropagation();
				document.getElementById('VRoid_test_camera_custom').checked = false;
				Object.values(transformControlsMap).forEach(transformControls => {
					thisLayer.scene.remove(transformControls);
					transformControls.dispose();
				});
				transformControlsMap = {};
				$(".VRoid_test_camera_custom_ui").remove()
				$("#yure_range_div").css("display", "")
				
				//待機モーションを更新
				this.saveWaitingAnimationVal(vrm.humanoid, model)
				model.isAnimating = tmpIsAnimating

				$("#VRoid_test_camera_custom").one("click", (e) => {
					e.stopPropagation();
					document.getElementById('VRoid_test_camera_custom').checked = true;
					this.useTransformControls(modelID)
				});

			});

			$VRoid_test_camera_undo.css("opacity", "0.5").on("click", (e) => {
				if (historyData.length === 0) return
				
				$VRoid_test_camera_redo.css("opacity", "")
				historyData2.push(vrm.humanoid.getNormalizedPose())
				vrm.humanoid.setNormalizedPose(historyData.pop())
				if (historyData.length === 0) $VRoid_test_camera_undo.css("opacity", "0.5")

				$VRoid_test_camera_bonex.text("")
				$VRoid_test_camera_boney.text("")
				$VRoid_test_camera_bonez.text("")
			})
			
			$VRoid_test_camera_redo.css("opacity", "0.5").on("click", (e) => {
				if (historyData2.length === 0) return
				
				$VRoid_test_camera_undo.css("opacity", "")
				historyData.push(vrm.humanoid.getNormalizedPose())
				vrm.humanoid.setNormalizedPose(historyData2.pop())

				if (historyData2.length === 0) $VRoid_test_camera_redo.css("opacity", "0.5")

				$VRoid_test_camera_bonex.text("")
				$VRoid_test_camera_boney.text("")
				$VRoid_test_camera_bonez.text("")

			})
			
			$VRoid_test_camera_betsu.css("opacity", "0.5").on("click", (e) => {
				$VRoid_test_camera_betsu.css("opacity", "0.5")
				$VRoid_test_camera_bonename.text("")
				$VRoid_test_camera_bonex.text("")
				$VRoid_test_camera_boney.text("")
				$VRoid_test_camera_bonez.text("")
				Object.values(transformControlsMap).forEach(tc => {
					tc.size = tcSize;
					tc.visible = true;
					tc.enabled = true;
				})
			})

			$("#VRoid_test_camera_import").on("click", (e) => {
				//ポーズデータのインポート
				const input = document.createElement("input");
				input.type = "file";
				 
				input.addEventListener("change", e => {

					var result = e.target.files[0];
					var reader = new FileReader();

					reader.readAsText(result);
					reader.addEventListener("load", () => {

						let json
						try{
							json = JSON.parse(reader.result);
							vrm.humanoid.setNormalizedPose(json)
						}catch(e){
							alert("インポートしたファイルの形式が不正です！")
						}
					});
				});
				 
				//ダイアログを表示
				input.click();
				e.stopPropagation();
			})

			$("#VRoid_test_camera_export").on("click", (e) => {
				//ポーズデータのエクスポート
				const poseData = vrm.humanoid.getNormalizedPose()
				
				//positionを削除
				Object.keys(poseData).forEach((key) => {
					if (poseData[key].position) delete poseData[key].position
				});
				const json = JSON.stringify(poseData, null, 2);
				const link = document.createElement("a");
				const ymd = new Date().toLocaleDateString('sv-SE');
				const time = new Date().toLocaleTimeString('ja-JP', {hour12:false});

				link.href = "data:text/plain," + encodeURIComponent(json);
				link.download = "new_pose_" + ymd + "_" + time + ".json";
				 
				//ファイルを保存
				link.click();
				e.stopPropagation();
			})

			$("#VRoid_test_camera_lookAt").on("click", (e) => {
				//カメラ目線のオンオフ
				e.stopPropagation();
			})

			//指スライダー処理
			$(".yubi_range").on('change input', function handler() {
				const id = $(this).attr('id')
				const val = parseFloat($(this).val())
				
				if (id.includes("right")) {
					if (document.getElementById('yubi_r_ikkatu').checked) {
						ikkatu(id, val)
						return
					}
				} else {
					if (document.getElementById('yubi_l_ikkatu').checked) {
						ikkatu(id, val)
						return
					}
				}
				
				$("#" + id + "_val").text(val.toFixed(2))
				setFingerPose(id, val)

				function ikkatu (id, val) {
					let lr = "left"
					if (id.includes("right")) lr = "right"
					
					$(".yubi_range").off("change input", handler);
					 
					const Thumb = lr + "Thumb"
					const Index = lr + "Index"
					const Middle = lr + "Middle"
					const Ring = lr + "Ring"
					const Little = lr + "Little"

					document.getElementById(Thumb).value = val;
					document.getElementById(Index).value = val;
					document.getElementById(Middle).value = val;
					document.getElementById(Ring).value = val;
					document.getElementById(Little).value = val;

					$("#" + Thumb + "_val").text(val.toFixed(2))
					$("#" + Index + "_val").text(val.toFixed(2))
					$("#" + Middle + "_val").text(val.toFixed(2))
					$("#" + Ring + "_val").text(val.toFixed(2))
					$("#" + Little + "_val").text(val.toFixed(2))

					setFingerPose(Thumb, val)
					setFingerPose(Index, val)
					setFingerPose(Middle, val)
					setFingerPose(Ring, val)
					setFingerPose(Little, val)
					
					$(".yubi_range").on("change input", handler);
				}

			});

			//指処理
			function setFingerPose (fingerName, poseStrength) {
				const fingerList = [
					"rightThumbProximal",
					"rightThumbDistal",

					"rightIndexProximal",
					"rightIndexIntermediate",
					"rightIndexDistal",

					"rightMiddleProximal",
					"rightMiddleIntermediate",
					"rightMiddleDistal",

					"rightRingProximal",
					"rightRingIntermediate",
					"rightRingDistal",

					"rightLittleProximal",
					"rightLittleIntermediate",
					"rightLittleDistal",


					"leftThumbProximal",
					"leftThumbDistal",

					"leftIndexProximal",
					"leftIndexIntermediate",
					"leftIndexDistal",

					"leftMiddleProximal",
					"leftMiddleIntermediate",
					"leftMiddleDistal",

					"leftRingProximal",
					"leftRingIntermediate",
					"leftRingDistal",

					"leftLittleProximal",
					"leftLittleIntermediate",
					"leftLittleDistal",
				]

				const isRightHand = fingerName.includes("right");
				const isThumb = fingerName.includes("Thumb");
				const direction = isRightHand ? -1 : 1;
				let thumbScale = 1;

				fingerList.forEach((boneName) => {
					if (!boneName.includes(fingerName)) return;

					const bone = vrm.humanoid.getNormalizedBoneNode(boneName);
					if (!bone) return;

					if (isThumb) {
						bone.rotation.y = direction * poseStrength * Math.PI * 0.5 * thumbScale;
						thumbScale *= 0.6;
					} else {
						bone.rotation.z = direction * poseStrength * Math.PI * 0.5;
					}
				});

			};
		},

		importModule: async function (name, url) {
			const module = await import(url);
			if (name) {
				return module[name];
			}
		},

		effectList: {
			AFTERIMAGE: {
				AfterimagePass: "./module/three/postprocessing/AfterimagePass.js",
			},

			BLOOM: {
				BloomPass: "./module/three/postprocessing/BloomPass.js",
			},

			BOKEH: {	//不具合あり（追加した画像の完全透過部分が処理されない。仕様？）
				BokehPass: "./module/three/postprocessing/BokehPass.js",
			},

			DOTSCREEN: {
				DotScreenPass: "./module/three/postprocessing/DotScreenPass.js",
			},
			
			FILM: {
				FilmPass: "./module/three/postprocessing/FilmPass.js",
			},
			
			GLITCH: {
				GlitchPass: "./module/three/postprocessing/GlitchPass.js",
			},
			
			
			RENDERPIXELATED: {
				RenderPixelatedPass: "./module/three/postprocessing/RenderPixelatedPass.js",
			},
			
			UNREALBLOOM: {
				UnrealBloomPass: "./module/three/postprocessing/UnrealBloomPass.js",
			},
			
			
			HORIZONTALBLUR: {
				HorizontalBlurShader: "./module/three/shaders/HorizontalBlurShader.js",
			},
			
			MIRROR: {
				MirrorShader: "./module/three/shaders/MirrorShader.js",
			},

		},

		//エフェクトをプリロードするときに使う
		effect_import: async function (name, cb) {
			const statModule = TYRANO.kag.stat.VRoid.module;

			//大文字に統一
			name = name.toUpperCase()

			if (this.effectList[name]) {
				for (let key in this.effectList[name]) {
					const url = this.effectList[name][key]
					//セーブデータにプリロード済みフラグを設定
					statModule[url] = true
					await this.importModule(key, url)
				}
				
				//GammaCorrectionShaderは全module共通
				const url = "./module/three/shaders/GammaCorrectionShader.js"
				statModule[url] = true
				await this.importModule("GammaCorrectionShader", url)
			}
			
			if (cb && typeof cb === 'function') cb()

		},


		//VRoid.three.effect("VRoid", "Afterimage", {})
		effect: async function (layerID, name, option, cb) {
			const thisLayer = this.layer[layerID];
			const statVRoid = TYRANO.kag.stat.VRoid;
			const saveLayer = statVRoid.layer[layerID];
			
			if (!thisLayer.effect) thisLayer.effect = {};
			if (!saveLayer.effect) saveLayer.effect = [];
			
			//大文字に統一
			name = name.toUpperCase()

			//既に設定されていた場合は削除
			if (thisLayer.effect[name]) {
				thisLayer.effect[name].forEach((number) => {
					thisLayer.composer.removePass(number);
				});
			}
			thisLayer.effect[name] = []
			
			saveLayer.effect.forEach((number, index) => {
				if (number.name === name) {
					saveLayer.effect.splice(index, 1)
				}
			});

			//何らかのeffectが有効になったらtrue
			let isEffect = false

			switch (name) {
				case "AFTERIMAGE":
					isEffect = true
					//セーブデータに保存
					saveLayer.effect.push( {"name": name, "option": option} )

					const AfterimagePass = await this.importModule("AfterimagePass", this.effectList[name].AfterimagePass)

					//初期値の設定
					//constructor( damp = 0.96 )
					if (option.damp === undefined) option.damp = 0.96
					
					thisLayer.effect[name].push( new AfterimagePass(option.damp) )
					thisLayer.composer.addPass( thisLayer.effect[name][0] );

					break;


				case "BLOOM":
					isEffect = true
					//セーブデータに保存
					saveLayer.effect.push( {"name": name, "option": option} )
				
					const BloomPass = await this.importModule("BloomPass", this.effectList[name].BloomPass)

					//初期値の設定
					//constructor( strength = 1, kernelSize = 25, sigma = 4 )
					if (option.strength === undefined) option.strength = 1.25
					if (option.kernelSize === undefined) option.kernelSize = 5
					if (option.sigma === undefined) option.sigma = 0.5
					
					thisLayer.effect[name].push( new BloomPass(option.strength, option.kernelSize, option.sigma) )
					thisLayer.composer.addPass( thisLayer.effect[name][0] );

					break;


				case "BOKEH":
					isEffect = true
					//セーブデータに保存
					saveLayer.effect.push( {"name": name, "option": option} )
				
					const BokehPass = await this.importModule("BokehPass", this.effectList[name].BokehPass)

					//初期値の設定
					//constructor( scene, camera, {focus=1.0, aperture=0.025, maxblur=1.0} )
					if (option.focus === undefined) option.focus = 1.5
					if (option.aperture === undefined) option.aperture = 0.01
					if (option.maxblur === undefined) option.maxblur = 1
					
					thisLayer.effect[name].push( new BokehPass(thisLayer.scene, thisLayer.camera, {focus:option.focus, aperture:option.aperture, maxblur:option.maxblur}) )
					thisLayer.composer.addPass( thisLayer.effect[name][0] );
				
					break;


				case "DOTSCREEN":
					isEffect = true
					//セーブデータに保存
					saveLayer.effect.push( {"name": name, "option": option} )
				
					const DotScreenPass = await this.importModule("DotScreenPass", this.effectList[name].DotScreenPass)

					//初期値の設定
					//constructor( center=new THREE.Vector2( 0.5, 0.5 ), angle=1.57, scale=1 )
					if (option.centerX === undefined) option.centerX = 0.5
					if (option.centerY === undefined) option.centerY = 0.5
					if (option.angle === undefined) option.angle = 1.57
					if (option.scale === undefined) option.scale = 1
					
					thisLayer.effect[name].push( new DotScreenPass(new THREE.Vector2( option.centerX, option.centerY ), option.angle, option.scale) )
					thisLayer.composer.addPass( thisLayer.effect[name][0] );

					break;


				case "FILM":
					isEffect = true
					//セーブデータに保存
					saveLayer.effect.push( {"name": name, "option": option} )
				
					const FilmPass = await this.importModule("FilmPass", this.effectList[name].FilmPass)

					//初期値の設定
					//constructor( intensity = 0.5, grayscale = false)
					if (option.intensity === undefined) option.intensity = 1
					if (option.grayscale === undefined) option.grayscale = true
					
					thisLayer.effect[name].push( new FilmPass(option.intensity, option.grayscale) )
					thisLayer.composer.addPass( thisLayer.effect[name][0] );
				
					break;


				case "GLITCH":
					isEffect = true
					//セーブデータに保存
					saveLayer.effect.push( {"name": name, "option": option} )
				
					const GlitchPass = await this.importModule("GlitchPass", this.effectList[name].GlitchPass)

					//初期値の設定
					//constructor( dt_size = 64 )
					if (option.dt_size === undefined) option.dt_size = 64
					if (option.goWild === undefined) option.goWild = false
					
					thisLayer.effect[name].push( new GlitchPass(option.dt_size) )
					thisLayer.effect[name][0].goWild = option.goWild
					thisLayer.composer.addPass( thisLayer.effect[name][0] );
				
					break;


				case "RENDERPIXELATED":
					isEffect = true
					//セーブデータに保存
					saveLayer.effect.push( {"name": name, "option": option} )
				
					const RenderPixelatedPass = await this.importModule("RenderPixelatedPass", this.effectList[name].RenderPixelatedPass)

					//初期値の設定
					//constructor( pixelSize, scene, camera, options = {} ) ※options部分は未使用
					if (option.pixelSize === undefined) option.pixelSize = 12
					
					thisLayer.effect[name].push( new RenderPixelatedPass(option.pixelSize, thisLayer.scene, thisLayer.camera) )
					thisLayer.composer.addPass( thisLayer.effect[name][0] );
				
					break;


				case "UNREALBLOOM":
					isEffect = true
					//セーブデータに保存
					saveLayer.effect.push( {"name": name, "option": option} )
				
					const UnrealBloomPass = await this.importModule("UnrealBloomPass", this.effectList[name].UnrealBloomPass)

					//初期値の設定
					//constructor( resolution=new THREE.Vector2( 256, 256 ), strength=1, radius=0, threshold=0 )
					if (option.strength === undefined) option.strength = 0.2	//光の強さ
					if (option.radius === undefined) option.radius = 1			//光の広がり　大きくするとよりボヤっと広がる
					if (option.threshold === undefined) option.threshold = 0.8	//閾値（1～0）
					
					thisLayer.effect[name].push( new UnrealBloomPass(new THREE.Vector2( thisLayer.renderer.domElement.width, thisLayer.renderer.domElement.height ), option.strength, option.radius, option.threshold) )
					thisLayer.composer.addPass( thisLayer.effect[name][0] );

					break;


				case "HORIZONTALBLUR":
					isEffect = true
					//セーブデータに保存
					saveLayer.effect.push( {"name": name, "option": option} )
				
					const HorizontalBlurShader = await this.importModule("HorizontalBlurShader", this.effectList[name].HorizontalBlurShader)

					//初期値の設定
					//constructor(  )
					
					thisLayer.effect[name].push( new ShaderPass(HorizontalBlurShader) )
					thisLayer.composer.addPass( thisLayer.effect[name][0] );

					break;


				case "MIRROR":
					isEffect = true
					//セーブデータに保存
					saveLayer.effect.push( {"name": name, "option": option} )
				
					const MirrorShader = await this.importModule("MirrorShader", this.effectList[name].MirrorShader)

					//初期値の設定
					//constructor(  )
					
					thisLayer.effect[name].push( new ShaderPass(MirrorShader) )
					thisLayer.composer.addPass( thisLayer.effect[name][0] );

					break;

				default:
					this.error("指定されたエフェクト名は存在しません")
			}
			
			//GammaCorrectionShaderを最後に追加する
			if (isEffect) {
				const GammaCorrectionShader = await this.importModule("GammaCorrectionShader", "./module/three/shaders/GammaCorrectionShader.js")
				if (thisLayer.effect["GammaCorrectionShader"]) {
					thisLayer.composer.removePass(thisLayer.effect["GammaCorrectionShader"][0]);
				}
				thisLayer.effect["GammaCorrectionShader"] = []
				thisLayer.effect["GammaCorrectionShader"].push( new ShaderPass(GammaCorrectionShader) )
				thisLayer.composer.addPass( thisLayer.effect["GammaCorrectionShader"][0] );
			}

			if (cb && typeof cb === 'function') cb()

		},

		//VRoid.three.effect_delete("VRoid", "Afterimage")
		effect_delete: function (layerID, name) {
			const thisLayer = this.layer[layerID];
			const statVRoid = TYRANO.kag.stat.VRoid;
			const saveLayer = statVRoid.layer[layerID];

			//name指定がなければ全消去
			if (!name) {
				if (thisLayer.effect) {
					for (let key in thisLayer.effect) {
						thisLayer.effect[key].forEach((number) => {
							thisLayer.composer.removePass(number);
						});
						delete thisLayer.effect[key]
					}
					delete saveLayer.effect
				}
			} else {
				//大文字に統一
				name = name.toUpperCase()

				if (thisLayer.effect && thisLayer.effect[name]) {
					thisLayer.effect[name].forEach((number) => {
						thisLayer.composer.removePass(number);
					});
					
					if (thisLayer.composer.passes.length <= 3) {
						//全てのエフェクトがなくなったらGammaCorrectionShaderも削除する
						if (thisLayer.effect["GammaCorrectionShader"]) {
							thisLayer.composer.removePass(thisLayer.effect["GammaCorrectionShader"][0]);
							delete thisLayer.effect["GammaCorrectionShader"]
						}
					}
					
					delete thisLayer.effect[name]
					saveLayer.effect.forEach((number, index) => {
						if (number.name === name) {
							saveLayer.effect.splice(index, 1)
						}
					});

				}
			}
		},

		//VRoid.three.showFPS("VRoid")
		showFPS: async function (layerID, cb) {
		
			//リロードボタンが存在している場合のみ処理
			if ($(".ui-draggable").length > 0) {
				const thisLayer = this.layer[layerID];
				
				if (!thisLayer.stats) {
					const Stats = await this.importModule("default", "./module/three/libs/stats.module.js")

					thisLayer.stats = new Stats();
					thisLayer.stats.showPanel(0);
					thisLayer.stats.dom.setAttribute("id", layerID + "statsPanel");
					$(".ui-draggable").append(thisLayer.stats.dom)
					$(thisLayer.stats.dom).css({"margin-top": "10px", "position": "initial"})
				}
			}
			
			if (cb && typeof cb === 'function') cb()
		},
		
		//VRoid.three.add_img( {layerID: "VRoid", imgID:"imgID", storage:"./data/bgimage/room.jpg", y: 1, z:-2, scaleX: 0.5, scaleY:0.5} )
		add_img: async function (pm, cb) {

			const { 
				layerID,
				storage,
				imgID,
				visible = true,
				x = 0,
				y = 0,
				z = 0,
				rotX = 0,
				rotY = 0,
				rotZ = 0,
				scaleX = 1,
				scaleY = 1,
				scaleZ = 0,
				time = 0,
				easing = "default",
				wait = true,
				skip = false,
				cache = true,
			} = pm;


			//セーブ領域の作成
			const tStat = TYRANO.kag.stat
			const saveImg = tStat.VRoid.img
			pm.time = 0
			pm.wait = true
			pm.type = "img"
			saveImg[imgID] = $.extend(true,{}, pm);

			const thisLayer = this.layer[layerID];
			
			let cacheUrl = ""
			if (!cache) cacheUrl = "?" + new Date().getTime()

			let mesh = this.img[imgID]
			if (mesh) {
				//既に同じIDがあった場合は削除してから処理を進める
				cancelAnimationFrame(mesh.tickID)
				mesh.geometry.dispose();
				mesh.material.dispose();
				thisLayer.scene.remove( mesh );
				mesh = null;
			}

			const loader = new THREE.TextureLoader();
			loader.crossOrigin = 'anonymous';
			const texture = loader.load(storage + cacheUrl, 

				(texture) => {
					texture.colorSpace = THREE.SRGBColorSpace;
					texture.minFilter = THREE.LinearFilter;
					texture.magFilter = THREE.LinearFilter;

					texture.wrapS = THREE.ClampToEdgeWrapping;
					texture.wrapT = THREE.ClampToEdgeWrapping;

					const width = texture.image.width / 500;
					const height = texture.image.height / 500;

					const geometry = new THREE.PlaneGeometry(width, height, 1, 1);
					const material = new THREE.MeshBasicMaterial({
						map: texture,
						transparent: true,
						opacity: 0,
						side: THREE.DoubleSide,
					});

					this.img[imgID] = new THREE.Mesh(geometry, material);
					mesh = this.img[imgID]
					
					mesh.layerID = layerID;
					mesh.frustumCulled = false;

					mesh.position.x = x
					mesh.position.y = y
					mesh.position.z = z
					
					mesh.rotation.x = rotX
					mesh.rotation.y = rotY
					mesh.rotation.z = rotZ

					mesh.scale.x = scaleX
					mesh.scale.y = scaleY
					mesh.scale.z = scaleZ
					
					//ライトの状態をみて色合い変更
					const meshMaterial = mesh.material
					const intensityVal = thisLayer.light.intensity !== 0 ? thisLayer.light.intensity / Math.PI : 0
					meshMaterial.color.r = thisLayer.light.color.r * intensityVal
					meshMaterial.color.g = thisLayer.light.color.g * intensityVal
					meshMaterial.color.b = thisLayer.light.color.b * intensityVal
					
					mesh.visible = visible

					thisLayer.scene.add(mesh);

					const easingFunc = this.easing[easing];
					const startTime = performance.now();

					const tick = (timestamp) => {
						const elapsedTime = timestamp - startTime;

						let progress
						if (time !== 0) {
							progress = Math.max(0, Math.min(elapsedTime / time, 1))
						} else {
							progress = 1
						}

						//スキップが有効の場合は割り込み処理
						if (skip && tStat.is_skip) progress = 1
						
						meshMaterial.opacity = easingFunc(progress);

						if (progress < 1) {
							mesh.tickID = requestAnimationFrame(tick);
						} else {
							//setTimeoutで呼び出さないと後続のコードのエラーまでcatchしてしまう
							if (cb && typeof cb === 'function' && wait) setTimeout(cb, 0)
						}
					};
					tick(startTime);

					//waitがfalseの時は即NextOrder
					//setTimeoutで呼び出さないと後続のコードのエラーまでcatchしてしまう
					if (cb && typeof cb === 'function' && !wait) setTimeout(cb, 0)
			
				},
				undefined,
				(error) => {
					//読み込み失敗時
					console.error(storage + " のロードに失敗しました：", error);
					if (cb && typeof cb === 'function') cb()
				}
			)

		},

		//VRoid.three.delete_img( {imgID:"imgID", time:1000} )
		delete_img: function (pm, cb) {
			const { 
				imgID,
				time = 0,
				wait = true,
				skip = false,
				easing = "default",
			} = pm;

			//セーブ領域の削除
			const tStat = TYRANO.kag.stat
			const saveImg = tStat.VRoid.img
			delete saveImg[imgID]

			const mesh = this.img[imgID]
			if (!mesh) {
				//存在しないIDであれば即return
				if (cb && typeof cb === 'function') cb()
				return
			}
			
			const thisLayer = this.layer[mesh.layerID];

			cancelAnimationFrame(mesh.tickID)
			const easingFunc = this.easing[easing];
			const startTime = performance.now();

			const tick = (timestamp) => {
				const elapsedTime = timestamp - startTime;

				let progress
				if (time !== 0) {
					progress = Math.max(0, Math.min(elapsedTime / time, 1))
				} else {
					progress = 1
				}

				//スキップが有効の場合は割り込み処理
				if (skip && tStat.is_skip) progress = 1
				
				mesh.material.opacity = 1 - easingFunc(progress);

				if (progress < 1) {
					mesh.tickID = requestAnimationFrame(tick);
				} else {
					mesh.geometry.dispose();
					mesh.material.dispose();
					thisLayer.scene.remove( mesh );

					delete this.img[imgID]

					if (cb && typeof cb === 'function' && wait) cb()
				}
			};
			tick(startTime);

			//waitがfalseの時は即NextOrder
			if (cb && typeof cb === 'function' && !wait) cb()

		},

		//VRoid.three.show_img( {imgID:"imgID", time:1000} )
		show_img: function (pm, cb) {
			const { 
				imgID,
				time = 0,
				wait = true,
				skip = false,
				easing = "default",
			} = pm;


			const mesh = this.img[imgID]
			if (!mesh) {
				//存在しないIDであれば即return
				if (cb && typeof cb === 'function') cb()
				return
			}

			//セーブデータの更新
			const tStat = TYRANO.kag.stat
			const saveImg = tStat.VRoid.img[imgID]
			saveImg.visible = true

			const thisLayer = this.layer[mesh.layerID];

			mesh.material.opacity = 0
			mesh.visible = true

			cancelAnimationFrame(mesh.tickID)
			const easingFunc = this.easing[easing];
			const startTime = performance.now();

			const tick = (timestamp) => {
				const elapsedTime = timestamp - startTime;

				let progress
				if (time !== 0) {
					progress = Math.max(0, Math.min(elapsedTime / time, 1))
				} else {
					progress = 1
				}

				//スキップが有効の場合は割り込み処理
				if (skip && tStat.is_skip) progress = 1
				
				mesh.material.opacity = easingFunc(progress);

				if (progress < 1) {
					mesh.tickID = requestAnimationFrame(tick);
				} else {
					if (cb && typeof cb === 'function' && wait) cb()
				}
			};
			tick(startTime);

			//waitがfalseの時は即NextOrder
			if (cb && typeof cb === 'function' && !wait) cb()

		},

		//VRoid.three.hide_img( {imgID:"imgID", time:1000} )
		hide_img: function (pm, cb) {
			const { 
				imgID,
				time = 0,
				wait = true,
				skip = false,
				easing = "default",
			} = pm;


			const mesh = this.img[imgID]
			if (!mesh) {
				//存在しないIDであれば即return
				if (cb && typeof cb === 'function') cb()
				return
			}

			//セーブデータの更新
			const tStat = TYRANO.kag.stat
			const saveImg = tStat.VRoid.img[imgID]
			saveImg.visible = false

			const thisLayer = this.layer[mesh.layerID];

			mesh.material.opacity = 1
			//showと違い、既に隠れているものは隠れたままという仕様の方が使いやすそう
			//mesh.visible = true

			cancelAnimationFrame(mesh.tickID)
			const easingFunc = this.easing[easing];
			const startTime = performance.now();

			const tick = (timestamp) => {
				const elapsedTime = timestamp - startTime;

				let progress
				if (time !== 0) {
					progress = Math.max(0, Math.min(elapsedTime / time, 1))
				} else {
					progress = 1
				}

				//スキップが有効の場合は割り込み処理
				if (skip && tStat.is_skip) progress = 1
				
				mesh.material.opacity = 1 - easingFunc(progress);

				if (progress < 1) {
					mesh.tickID = requestAnimationFrame(tick);
				} else {
					mesh.visible = false
					if (cb && typeof cb === 'function' && wait) cb()
				}
			};
			tick(startTime);

			//waitがfalseの時は即NextOrder
			if (cb && typeof cb === 'function' && !wait) cb()

		},

		//VRoid.three.move( {type:"img", id:"imgID", x:-2, y:0.5, time:1000} )
		move: function (pm, cb) {

			//カメラのみscaleではなくzoomを使用可
			const {
				type,	//layer or model or img
				x,
				y,
				z,
				rotX,
				rotY,
				rotZ,
				scaleX,
				scaleY,
				scaleZ,
				zoom,
				time = 0,
				wait = true,
				skip = false,
				easing = "default",
			} = pm;
			
			const id = pm[type + "ID"]

			const objID = this[type][id]
			if (objID === undefined) {
				//そんなIDは存在しない
				if (cb && typeof cb === 'function') cb()
				return
			}
			
			//typeによって変更する箇所を選択
			let objType
			if (type == "layer") {
				objType = objID.camera
			} else if (type == "model"){
				objType = objID.vrm.scene
			} else if (type == "img"){
				objType = objID
			}
			

			//開始時の状態を保存
			const startVal = {
				x: objType.position.x,
				y: objType.position.y,
				z: objType.position.z,
				rotX: objType.rotation.x,
				rotY: objType.rotation.y,
				rotZ: objType.rotation.z,
				scaleX: objType.scale.x,
				scaleY: objType.scale.y,
				scaleZ: objType.scale.z,
				zoom: objType.zoom,
			}

			//セーブデータ
			const tStat = TYRANO.kag.stat
			const saveData = tStat.VRoid[type][id]

			//終了時の状態を保存
			const endVal = {
				x: createTarget(x, saveData.x || 0),
				y: createTarget(y, saveData.y || 0),
				z: createTarget(z, saveData.z || 0),
				rotX: createTarget(rotX, saveData.rotX || 0),
				rotY: createTarget(rotY, saveData.rotY || 0),
				rotZ: createTarget(rotZ, saveData.rotZ || 0),
				scaleX: createTarget(scaleX, saveData.scaleX || 1),
				scaleY: createTarget(scaleY, saveData.scaleY || 1),
				scaleZ: createTarget(scaleZ, saveData.scaleZ || 1),
				zoom: createTarget(zoom, saveData.zoom || 1),
			}
			
			//zoomがあるのはlayerだけ
			const isLayer = (type == "layer")
			if (isLayer) {
				//cameraのscaleにマイナス値が入るとテクスチャーがバグるから0以下にさせない
				if (endVal.scaleX < 0) endVal.scaleX = 0
				if (endVal.scaleY < 0) endVal.scaleY = 0
				if (endVal.scaleZ < 0) endVal.scaleZ = 0
			}
			
			//モデルはscaleに0が入るとテクスチャーが崩壊するから避ける
			//0.000000000000000000000000001を指定
			const isModel = (type == "model")
			if (isModel) {
				if (endVal.scaleX === 0) endVal.scaleX = 0.000000000000000000000000001
				if (endVal.scaleY === 0) endVal.scaleY = 0.000000000000000000000000001
				if (endVal.scaleZ === 0) endVal.scaleZ = 0.000000000000000000000000001
			}

			//セーブデータに保存
			for (const key in endVal) {
				saveData[key] = endVal[key]
			}
			//復元に使用するtimeとwaitを強制上書き
			saveData.wait = true
			saveData.time = 0

			//VRM1.0の場合はrotYに補正が必要
			const correctionRotateY = objID.correctionRotateY || 0
			endVal.rotY += correctionRotateY

			//先に計算できる値をキャッシュ
			const moveX = endVal.x - startVal.x
			const moveY = endVal.y - startVal.y
			const moveZ = endVal.z - startVal.z

			const moveRotX = endVal.rotX - startVal.rotX
			const moveRotY = endVal.rotY - startVal.rotY
			const moveRotZ = endVal.rotZ - startVal.rotZ

			const moveScaleX = endVal.scaleX - startVal.scaleX
			const moveScaleY = endVal.scaleY - startVal.scaleY
			const moveScaleZ = endVal.scaleZ - startVal.scaleZ
			
			const moveZoom = endVal.zoom - startVal.zoom

			cancelAnimationFrame(objID.moveTickID)
			const easingFunc = this.easing[easing];
			const startTime = performance.now();

			const tick = (timestamp) => {
				const elapsedTime = timestamp - startTime;

				let progress
				if (time !== 0) {
					progress = Math.max(0, Math.min(elapsedTime / time, 1))
				} else {
					progress = 1
				}

				//スキップが有効の場合は割り込み処理
				if (skip && tStat.is_skip) progress = 1
				
				const val = easingFunc(progress);

				objType.position.set (
					val * moveX + startVal.x,
					val * moveY + startVal.y,
					val * moveZ + startVal.z
				)

				objType.rotation.set (
					val * moveRotX + startVal.rotX,
					val * moveRotY + startVal.rotY,
					val * moveRotZ + startVal.rotZ
				)

				let sx = val * moveScaleX + startVal.scaleX;
				let sy = val * moveScaleY + startVal.scaleY;
				let sz = val * moveScaleZ + startVal.scaleZ;

				if (isModel) {
					if (sx === 0) sx = 0.000000000000000000000000001
					if (sy === 0) sy = 0.000000000000000000000000001
					if (sz === 0) sz = 0.000000000000000000000000001
				}

				objType.scale.set(sx, sy, sz)

				//layerのみzoom対象　変化があったら実行
				if (isLayer && endVal.zoom !== startVal.zoom) {
					objType.zoom = val * moveZoom + startVal.zoom;
					objType.updateProjectionMatrix()
				}

				if (progress < 1) {
					objID.moveTickID = requestAnimationFrame(tick);
				} else {
					if (cb && typeof cb === 'function' && wait) cb()
				}
			};
			tick(startTime);

			//waitがfalseの時は即NextOrder
			if (cb && typeof cb === 'function' && !wait) cb()


			function createTarget(val, initialVal) {
				//ないものはない
				if (initialVal === undefined) return undefined
				
				//変更する値がない場合は現在値(セーブ値)を返す
				if (val === undefined) return initialVal
			
				//先頭2文字を取得
				const str = String(val).slice(0, 2);
				const tmpVal = Number(String(val).slice(2))
				let endVal;

				if (str == "+=") {
					endVal = initialVal + tmpVal
				} else if (str == "-=") {
					endVal = initialVal - tmpVal
				} else if (str == "*=") {
					endVal = initialVal * tmpVal
				} else if (str == "/=") {
					//0除算回避
					if ( tmpVal !== 0 ) {
						targetVal = initialVal / tmpVal
					} else {
						targetVal = 0
					}
				} else if (str == "%=") {
					endVal = initialVal % tmpVal
				} else {
					//いずれでもない場合は数字のはず
					endVal = Number(val)
				}
				
				return endVal;
			}

		},

		changeTexture: async function (pm, cb) {
			const {
				modelID,
				materialID,
				storage,
				outline = true,
			} = pm;
			
			const saveModel = TYRANO.kag.stat.VRoid.model[modelID];
			const materials = this.model[modelID].vrm.materials
			
			
			try {

				const texture = await this.getTexture("./data/others/plugin/vrm/_texture/" + storage)

				//materialIDからnameを取得
				let name
				for (const key in saveModel.material) {
					if (saveModel.material[key].id == materialID) name = key
				}

				let outlineName
				if (name) {
					outlineName = name + " (Outline)"
					for (const key in materials) {
						const mateName = materials[key].name
						if (name == mateName) {
							materials[key].map = texture;
							materials[key].shadeMultiplyTexture = texture;
							saveModel.material[name].storage = storage;
						}
					}
				}

				//アウトラインも処理するかどうか
				//次のIDの名前の後ろに" (Outline)"を付けたものと一致した場合は処理する
				if (outline) {
					name = null
					const nextMaterialID = Number(materialID) + 1
					for (const key in saveModel.material) {
						if (saveModel.material[key].id == nextMaterialID) name = key
					}

					if (name && outlineName == name) {
						for (const key in materials) {
							const mateName = materials[key].name
							if (name == mateName) {
								materials[key].map = texture;
								materials[key].shadeMultiplyTexture = texture;
								saveModel.material[name].storage = storage;
							}
						}
					}
				}

				//setTimeoutで呼び出さないと後続のコードのエラーまでcatchしてしまう
				if (cb && typeof cb === 'function') setTimeout(cb, 0)

			} catch (error) {
				console.error(storage + " のロードに失敗しました：", error);
				if (cb && typeof cb === 'function') cb();
			}

		},

		getTexture: async function (url) {
			return new Promise((resolve, reject) => {
				const loader = new THREE.TextureLoader();
				loader.crossOrigin = 'anonymous';
				loader.load(
					url,
					(texture) => {
						texture.colorSpace = THREE.SRGBColorSpace;
						texture.minFilter = THREE.LinearFilter;
						texture.magFilter = THREE.LinearFilter;
						texture.flipY = false;
						resolve(texture);
					},
					undefined,
					(error) => {
						reject(error);
					}
				);
			});
		},

		//マテリアルの色変更
		changeColor: function (pm, cb) {

			const {
				modelID,
				materialID,
				r,
				g,
				b,
				shadeR,
				shadeG,
				shadeB,
				time = 0,
				wait = true,
				skip = false,
				easing = "default",
			} = pm;

			const saveModel = TYRANO.kag.stat.VRoid.model[modelID];
			const thisModel = this.model[modelID]
			const materials = thisModel.vrm.materials
			let material
			let saveData
			
			//アウトラインかどうかで処理を変える
			let isOutline

			//materialIDから変更するマテリアルを取得
			let name
			for (const key in saveModel.material) {
				if (saveModel.material[key].id == materialID) {
					name = key

					//セーブデータの取得となかったら初期化
					if (!saveModel.material[key].color) saveModel.material[key].color = {}
					saveData = saveModel.material[key].color
				}
			}

			if (name) {
				for (const key in materials) {
					const mateName = materials[key].name
					if (name == mateName) {
						material = materials[key]
					}
				}
				
				//アウトライン判定
				if (name.endsWith(" (Outline)")) isOutline = true
				
			}

			if (!material) {
				//そんなマテリアルは存在しない
				if (cb && typeof cb === 'function') cb()
				return
			}
			
			let tmpR = material.color.r
			let tmpG = material.color.g
			let tmpB = material.color.b
			if (isOutline) {
				tmpR = material.outlineColorFactor.r
				tmpG = material.outlineColorFactor.g
				tmpB = material.outlineColorFactor.b
			}

			//開始時の状態を保存
			const startVal = {
				r: tmpR,
				g: tmpG,
				b: tmpB,
				shadeR: material.shadeColorFactor.r,
				shadeG: material.shadeColorFactor.g,
				shadeB: material.shadeColorFactor.b,
			}


			//終了時の状態を保存
			const endVal = {
				r: createTarget(r, saveData.r || tmpR),
				g: createTarget(g, saveData.g || tmpG),
				b: createTarget(b, saveData.b || tmpB),
				shadeR: createTarget(shadeR, saveData.shadeR || material.shadeColorFactor.r),
				shadeG: createTarget(shadeG, saveData.shadeG || material.shadeColorFactor.g),
				shadeB: createTarget(shadeB, saveData.shadeB || material.shadeColorFactor.b),
			}

			//セーブデータに保存
			for (const key in endVal) {
				saveData[key] = endVal[key]
			}
			
			//アニメーション用IDの作成
			if (!thisModel.changeMaterialColorTickID) thisModel.changeMaterialColorTickID = {}

			cancelAnimationFrame(thisModel.changeMaterialColorTickID[materialID])
			const easingFunc = this.easing[easing];
			const startTime = performance.now();

			const tick = (timestamp) => {
				const elapsedTime = timestamp - startTime;

				let progress
				if (time !== 0) {
					progress = Math.max(0, Math.min(elapsedTime / time, 1))
				} else {
					progress = 1
				}

				//スキップが有効の場合は割り込み処理
				if (skip && tStat.is_skip) progress = 1
				
				const value = easingFunc(progress);

				const valR = startVal.r + (endVal.r - startVal.r) * value
				const valG = startVal.g + (endVal.g - startVal.g) * value
				const valB = startVal.b + (endVal.b - startVal.b) * value

				if (!isOutline) {
					material.color.set(valR, valG, valB)

					const valShadeR = startVal.shadeR + (endVal.shadeR - startVal.shadeR) * value
					const valShadeG = startVal.shadeG + (endVal.shadeG - startVal.shadeG) * value
					const valShadeB = startVal.shadeB + (endVal.shadeB - startVal.shadeB) * value
					material.shadeColorFactor.set(valShadeR, valShadeG, valShadeB)

				} else {
					material.outlineColorFactor.set(valR, valG, valB)
				}

				if (progress < 1) {
					thisModel.changeMaterialColorTickID[materialID] = requestAnimationFrame(tick);
				} else {
					if (cb && typeof cb === 'function' && wait) cb()
				}
			};
			tick(startTime);

			//waitがfalseの時は即NextOrder
			if (cb && typeof cb === 'function' && !wait) cb()


			function createTarget(value, initialVal) {
				//ないものはない
				if (initialVal === undefined) return undefined
				
				//変更する値がない場合は現在値(セーブ値)を返す
				if (value === undefined) return initialVal
			
				//先頭2文字を取得
				const str = String(value).slice(0, 2);
				const tmpVal = Number(String(value).slice(2))
				let endVal;

				if (str == "+=") {
					endVal = initialVal + tmpVal
				} else if (str == "-=") {
					endVal = initialVal - tmpVal
				} else if (str == "*=") {
					endVal = initialVal * tmpVal
				} else if (str == "/=") {
					//0除算回避
					if ( tmpVal !== 0 ) {
						targetVal = initialVal / tmpVal
					} else {
						targetVal = 0
					}
				} else if (str == "%=") {
					endVal = initialVal % tmpVal
				} else {
					//いずれでもない場合は数字のはず
					endVal = Number(value)
				}
				
				return endVal;
			}
		},

		// const THREE = VRoid.three.getTHREE()
		getTHREE: function () {
			return THREE
		},

		//エラー処理
		error: function (message, err) {
				const current_storage = TYRANO.kag.stat.current_scenario;
				const line = parseInt(TYRANO.kag.stat.current_line) + 1;
				const line_str = $.lang("line", { line });
				const error_str = `Error: ${current_storage}:${line_str}\n\n${message}`;
				if (err) {
					console.error(error_str, err)
				} else {
					console.error(error_str)
				}
			if (TYRANO.kag.config["debugMenu.visible"] == "true") {
				$.error_message(error_str);
			}
		},

	}

})();
